/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pageflip.impl;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.pageflip.ReaderConfig;

public class DoublePageReaderConfig
extends ReaderConfig {
    public static final String TAG = Constants.getTag(DoublePageReaderConfig.class);
    public static final Parcelable.Creator<DoublePageReaderConfig> CREATOR = new Parcelable.Creator<DoublePageReaderConfig>(){

        public DoublePageReaderConfig createFromParcel(Parcel source) {
            return new DoublePageReaderConfig(source);
        }

        public DoublePageReaderConfig[] newArray(int size) {
            return new DoublePageReaderConfig[size];
        }
    };

    public DoublePageReaderConfig() {
    }

    @Override
    public int pageToPosition(int[] pages) {
        return this.pageToPosition(pages[0]);
    }

    @Override
    public int pageToPosition(int page) {
        if (this.isLandscape() && page > 1) {
            page -= page % 2;
            return this.hasIntro() ? page / 2 + 1 : page / 2;
        }
        return this.hasIntro() ? page : page - 1;
    }

    @Override
    public int[] positionToPages(int position, int pageCount) {
        boolean landscape = this.isLandscape();
        if (this.hasIntro()) {
            if (position > 0) {
                --position;
            } else {
                return new int[0];
            }
        }
        if (this.hasOutro()) {
            int maxPagePos;
            int n = maxPagePos = landscape ? pageCount / 2 : pageCount - 1;
            if (maxPagePos < position) {
                return new int[0];
            }
        }
        int page = landscape && position > 0 ? position * 2 : position + 1;
        int[] pages = !landscape || page == 1 || page == pageCount ? new int[]{page} : new int[]{page, page + 1};
        return pages;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected DoublePageReaderConfig(Parcel in) {
        super(in);
    }
}

