/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pageflip;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.model.Images;
import com.shopgun.android.sdk.pageflip.utils.PageflipUtils;
import com.shopgun.android.sdk.utils.Utils;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.RequestCreator;
import com.squareup.picasso.Target;
import com.squareup.picasso.Transformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class PageLoader
implements ViewTreeObserver.OnPreDrawListener {
    public static final String TAG = Constants.getTag(PageLoader.class);
    private Picasso mPicasso;
    private ImageView mImageView;
    private final Object LOCK = new Object();
    private Bitmap mBitmap;
    private Config mConfig;
    private int mBitmapsLoadedCount = 0;
    private PageLoaderListener mListener;
    private Quality mQuality;
    private final List<PageTransformerTarget> mPageTransformerTargetReference = new ArrayList<PageTransformerTarget>();

    public PageLoader(Context ctx, int[] pages, Catalog c) {
        this(Picasso.with((Context)ctx), new Config(ctx, pages, c));
    }

    public PageLoader(Context ctx, Config config) {
        this(Picasso.with((Context)ctx), config);
    }

    public PageLoader(Picasso picasso, Config config) {
        this.mPicasso = picasso;
        this.mConfig = config;
    }

    public void into(ImageView imageView, Quality q) {
        if (imageView == this.mImageView && this.mQuality == q) {
            return;
        }
        this.cancel();
        this.mQuality = q;
        this.mImageView = imageView;
        this.mImageView.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.onPreDraw();
    }

    public boolean onPreDraw() {
        if (this.mImageView == null) {
            return true;
        }
        ViewTreeObserver vto = this.mImageView.getViewTreeObserver();
        if (!vto.isAlive()) {
            return true;
        }
        int width = this.mImageView.getWidth();
        int height = this.mImageView.getHeight();
        if (width <= 0 || height <= 0) {
            return true;
        }
        vto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.loadImages(width, height);
        return true;
    }

    private void loadImages(int width, int height) {
        for (int i = 0; i < this.mConfig.getPageCount(); ++i) {
            String url = this.mConfig.getUrl(this.mQuality, i);
            int page = this.mConfig.getPage(i);
            PageTransformerTarget t = new PageTransformerTarget(page);
            this.mPageTransformerTargetReference.add(t);
            RequestCreator rc = this.mPicasso.load(url);
            rc.tag(this.LOCK);
            if (this.mConfig.shouldResize(this.mQuality)) {
                rc.resize(width, height);
                rc.onlyScaleDown();
                rc.centerInside();
            }
            rc.transform((Transformation)t);
            rc.config(this.mConfig.getBitmapConfig());
            rc.into((Target)t);
        }
    }

    public PageLoader cancel() {
        ViewTreeObserver vto;
        if (this.mPicasso != null) {
            this.mPicasso.cancelTag(this.LOCK);
        }
        if (this.mImageView != null && (vto = this.mImageView.getViewTreeObserver()).isAlive()) {
            vto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }
        this.mPageTransformerTargetReference.clear();
        this.mBitmapsLoadedCount = 0;
        return this;
    }

    public PageLoader pause() {
        if (this.mPicasso != null) {
            this.mPicasso.pauseTag(this.LOCK);
        }
        return this;
    }

    public PageLoader resume() {
        if (this.mPicasso != null) {
            this.mPicasso.resumeTag(this.LOCK);
        }
        return this;
    }

    public boolean isDoneLoading() {
        return this.mBitmapsLoadedCount == this.mConfig.getPageCount();
    }

    public PageLoader setPageLoaderListener(PageLoaderListener l) {
        this.mListener = l;
        return this;
    }

    public PageLoaderListener getPageLoaderListener() {
        return this.mListener;
    }

    public static Bitmap createBitmapIfNotExists(Bitmap orig, Bitmap b, Bitmap.Config config, int[] pages) {
        boolean allowRetry = true;
        while (orig == null && allowRetry) {
            try {
                if (pages.length == 1) {
                    return b;
                }
                int w = b.getWidth() * pages.length;
                int h = b.getHeight();
                return Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)config);
            }
            catch (OutOfMemoryError e) {
                if (allowRetry) {
                    allowRetry = false;
                    SgnLog.e(TAG, e.getMessage(), e);
                    try {
                        Runtime.getRuntime().gc();
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e1) {
                        SgnLog.e(TAG, "Sleep failed");
                    }
                    continue;
                }
                throw e;
            }
        }
        return orig;
    }

    public static void drawOnto(Bitmap orig, Bitmap tmp, int page, int[] pages) {
        if (orig == null) {
            SgnLog.w(TAG, "Can't draw on double-page-bitmap it's null");
        } else if (orig.isRecycled()) {
            SgnLog.w(TAG, "Can't draw on double-page-bitmap it's recycled");
        } else {
            int pos = PageLoader.getPosition(page, pages);
            int widthOffset = pos * tmp.getWidth();
            Canvas c = new Canvas(orig);
            c.drawBitmap(tmp, (float)widthOffset, 0.0f, null);
        }
    }

    private static int getPosition(int page, int[] pages) {
        for (int i = 0; i < pages.length; ++i) {
            if (page != pages[i]) continue;
            return i;
        }
        return -1;
    }

    public static class Config
    implements Parcelable {
        private int mMaxMem;
        private int[] mPages;
        private List<String> mLow;
        private List<String> mMedium;
        private List<String> mHigh;
        Bitmap.Config mConfig;
        public static final Parcelable.Creator<Config> CREATOR = new Parcelable.Creator<Config>(){

            public Config createFromParcel(Parcel source) {
                return new Config(source);
            }

            public Config[] newArray(int size) {
                return new Config[size];
            }
        };

        public Config(Context ctx, int[] pages, Catalog c) {
            int heap = Utils.getMaxHeap(ctx);
            this.set(heap, pages, c);
        }

        public Config(int heap, int[] pages, Catalog c) {
            this.set(heap, pages, c);
        }

        private void set(int maxMem, int[] pages, Catalog c) {
            this.mMaxMem = maxMem;
            this.mPages = pages;
            this.mLow = this.getPagesUrls(c, Quality.MEDIUM, this.mPages);
            this.mMedium = this.getPagesUrls(c, Quality.MEDIUM, this.mPages);
            if (this.mMaxMem >= 96) {
                this.mConfig = Bitmap.Config.ARGB_8888;
                this.mHigh = this.getPagesUrls(c, Quality.HIGH, this.mPages);
            } else if (this.mMaxMem >= 48) {
                this.mConfig = Bitmap.Config.RGB_565;
                this.mHigh = this.getPagesUrls(c, Quality.HIGH, this.mPages);
            } else {
                this.mConfig = Bitmap.Config.RGB_565;
                this.mHigh = this.mMedium;
            }
        }

        public List<String> getPagesUrls(Catalog c, Quality q, int[] pages) {
            List<Images> images = c.getPages();
            ArrayList<String> urls = new ArrayList<String>(pages.length);
            block5: for (int i = 0; i < pages.length; ++i) {
                int pos = pages[i] - 1;
                Images img = images.get(pos);
                switch (q) {
                    case LOW: {
                        urls.add(img.getThumb());
                        continue block5;
                    }
                    case MEDIUM: {
                        urls.add(img.getView());
                        continue block5;
                    }
                    case HIGH: {
                        urls.add(img.getZoom());
                    }
                }
            }
            return urls;
        }

        public int getPage(int position) {
            return this.mPages[position];
        }

        public String getUrl(Quality q, int position) {
            switch (q) {
                case LOW: {
                    return this.mLow.get(position);
                }
                case MEDIUM: {
                    return this.mMedium.get(position);
                }
                case HIGH: {
                    return this.mHigh.get(position);
                }
            }
            return null;
        }

        public int getPageCount() {
            return this.mPages.length;
        }

        public boolean isSinglePage() {
            return this.mPages.length == 1;
        }

        public Bitmap.Config getBitmapConfig() {
            return this.mConfig;
        }

        public int[] getPages() {
            return this.mPages;
        }

        public boolean shouldResize(Quality q) {
            return q != Quality.HIGH;
        }

        public String toString() {
            String format = "%s[maxMem:%s, pages:%s, Bitmap.Config:%s, url.isSame:%s]";
            return String.format(format, TAG, this.mMaxMem, PageflipUtils.join(",", this.mPages), this.mConfig.toString(), this.mMedium == this.mHigh);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mMaxMem);
            dest.writeIntArray(this.mPages);
            dest.writeStringList(this.mLow);
            dest.writeStringList(this.mMedium);
            dest.writeStringList(this.mHigh);
            dest.writeInt(this.mConfig == null ? -1 : this.mConfig.ordinal());
        }

        protected Config(Parcel in) {
            this.mMaxMem = in.readInt();
            this.mPages = in.createIntArray();
            this.mLow = in.createStringArrayList();
            this.mMedium = in.createStringArrayList();
            this.mHigh = in.createStringArrayList();
            int tmpMConfig = in.readInt();
            this.mConfig = tmpMConfig == -1 ? null : Bitmap.Config.values()[tmpMConfig];
        }
    }

    public static enum Quality {
        LOW,
        MEDIUM,
        HIGH;

    }

    public class PageTransformerTarget
    implements Transformation,
    Target {
        int mPage;

        public PageTransformerTarget(int page) {
            this.mPage = page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Bitmap transform(Bitmap source) {
            source = PageLoader.this.mListener.onTransform(source, this.mPage);
            if (PageLoader.this.mConfig.isSinglePage()) {
                PageLoader.this.mBitmap = source;
            } else {
                Object object = PageLoader.this.LOCK;
                synchronized (object) {
                    int[] pages = PageLoader.this.mConfig.getPages();
                    PageLoader.this.mBitmap = PageLoader.createBitmapIfNotExists(PageLoader.this.mBitmap, source, PageLoader.this.mConfig.getBitmapConfig(), pages);
                    PageLoader.drawOnto(PageLoader.this.mBitmap, source, this.mPage, pages);
                }
            }
            return source;
        }

        public String key() {
            return TAG + this.mPage + new Random().nextFloat();
        }

        public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
            PageLoader.this.mBitmapsLoadedCount++;
            if (PageLoader.this.isDoneLoading()) {
                boolean bn = PageLoader.this.mBitmap == null;
                Bitmap b = bn ? bitmap : PageLoader.this.mBitmap;
                this.loadLog("onBitmapLoaded");
                this.loadLog("- " + PageLoader.this.mConfig.toString());
                this.loadLog("- mBitmap.bytes: " + PageflipUtils.sizeOfKb(b) + "kb");
                PageLoader.this.mImageView.setImageBitmap(b);
                if (PageLoader.this.mListener != null) {
                    PageLoader.this.mListener.onComplete();
                }
                PageLoader.this.mBitmap = null;
            }
        }

        public void onBitmapFailed(Drawable errorDrawable) {
            this.loadLog("onBitmapFailed");
            if (PageLoader.this.mListener != null) {
                PageLoader.this.mListener.onError();
            }
            PageLoader.this.mBitmap = null;
        }

        public void onPrepareLoad(Drawable placeHolderDrawable) {
            this.loadLog("onPrepareLoad");
        }

        private void loadLog(String s) {
        }
    }

    public static interface PageLoaderListener {
        public void onComplete();

        public void onError();

        public Bitmap onTransform(Bitmap var1, int var2);
    }
}

