/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pageflip;

import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.view.ViewGroup;
import com.shopgun.android.sdk.Constants;

public abstract class FragmentStatelessPagerAdapter
extends FragmentStatePagerAdapter {
    public static final String TAG = Constants.getTag(FragmentStatelessPagerAdapter.class);
    private Fragment[] mFragments;

    public FragmentStatelessPagerAdapter(FragmentManager fm) {
        super(fm);
    }

    public Fragment getItem(int position) {
        Fragment f;
        this.ensureFragmentArray();
        if (this.mFragments.length > position && (f = this.mFragments[position]) != null) {
            return f;
        }
        return this.createItem(position);
    }

    public abstract Fragment createItem(int var1);

    public Object instantiateItem(ViewGroup container, int position) {
        this.ensureFragmentArray();
        Object o = super.instantiateItem(container, position);
        this.mFragments[position] = (Fragment)o;
        return o;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        this.ensureFragmentArray();
        this.mFragments[position] = null;
        super.destroyItem(container, position, object);
    }

    public void clearState() {
        this.ensureFragmentArray();
        for (int i = 0; i < this.mFragments.length; ++i) {
            Fragment f = this.mFragments[i];
            if (f == null) continue;
            this.destroyItem(null, i, f);
        }
    }

    public Parcelable saveState() {
        this.ensureFragmentArray();
        if (this.isEmpty()) {
            return null;
        }
        return super.saveState();
    }

    private boolean isEmpty() {
        for (int i = 0; i < this.mFragments.length; ++i) {
            if (this.mFragments[i] == null) continue;
            return false;
        }
        return true;
    }

    private void ensureFragmentArray() {
        if (this.mFragments == null) {
            this.mFragments = new Fragment[this.getCount()];
        }
    }
}

