/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pageflip;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.pageflip.CatalogPageCallback;
import com.shopgun.android.sdk.pageflip.CatalogPageFragment;
import com.shopgun.android.sdk.pageflip.FragmentStatelessPagerAdapter;
import com.shopgun.android.sdk.pageflip.PageLoader;
import com.shopgun.android.sdk.pageflip.PageflipPage;
import com.shopgun.android.sdk.pageflip.ReaderConfig;

public class CatalogPagerAdapter
extends FragmentStatelessPagerAdapter {
    public static final String TAG = Constants.getTag(CatalogPagerAdapter.class);
    private CatalogPageCallback mCallback;
    private int mMaxHeap;
    private ReaderConfig mConfig;
    private Fragment mIntro;
    private Fragment mOutro;

    public CatalogPagerAdapter(FragmentManager fm, int maxHeap, CatalogPageCallback callback, ReaderConfig config) {
        super(fm);
        this.mMaxHeap = maxHeap;
        this.mCallback = callback;
        this.mConfig = config;
    }

    @Override
    public Fragment createItem(int position) {
        if (position == 0 && this.mIntro != null) {
            return this.mIntro;
        }
        if (position == this.getCount() - 1 && this.mOutro != null) {
            return this.mOutro;
        }
        Catalog c = this.mCallback.getCatalog();
        int[] pages = this.mConfig.positionToPages(position, c.getPageCount());
        PageLoader.Config config = new PageLoader.Config(this.mMaxHeap, pages, c);
        CatalogPageFragment f = CatalogPageFragment.newInstance(position, pages, config);
        f.setCatalogPageCallback(this.mCallback);
        return f;
    }

    public float getPageWidth(int position) {
        return ((PageflipPage)this.getItem(position)).getPageWidth();
    }

    public int getCount() {
        int count;
        int pc = this.mCallback.getCatalog().getPageCount();
        int n = count = this.mConfig.isLandscape() ? pc / 2 + 1 : pc;
        if (this.mIntro != null) {
            ++count;
        }
        if (this.mOutro != null) {
            ++count;
        }
        return count;
    }

    public void setIntroFragment(Fragment intro) {
        if (this.mIntro != intro) {
            this.mIntro = intro;
            this.mConfig.setHasIntro(this.mIntro != null);
            this.notifyDataSetChanged();
        }
        this.mConfig.setHasIntro(this.mIntro != null);
    }

    public void setOutroFragment(Fragment outro) {
        if (this.mOutro != outro) {
            this.mOutro = outro;
            this.mConfig.setHasOutro(this.mOutro != null);
            this.notifyDataSetChanged();
        }
        this.mConfig.setHasOutro(this.mOutro != null);
    }

    public String toString() {
        int pc = this.mCallback.getCatalog().getPageCount();
        String f = "%s[orientation:%s, pageCount:%s, viewCount:%s]";
        return String.format(f, TAG, this.mConfig.getOrientation().toString(), pc, this.getCount());
    }
}

