/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.mock;

import com.shopgun.android.sdk.network.Network;
import com.shopgun.android.sdk.network.NetworkResponse;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.network.mock.MockUnsupportedNetworkResponse;
import java.util.Random;

public abstract class MockNetwork
implements Network {
    long mDelayMin = 0L;
    long mDelayMax = 0L;

    @Override
    public NetworkResponse performRequest(Request<?> request) throws ShopGunError {
        if (this.mDelayMin > 0L) {
            try {
                int offset = (int)(this.mDelayMax - this.mDelayMin);
                int sleep = new Random().nextInt(offset + 1) + (int)this.mDelayMin;
                Thread.sleep(sleep);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new MockUnsupportedNetworkResponse(request);
    }

    public long getDelayMin() {
        return this.mDelayMin;
    }

    public void setDelayMin(long delayMin) {
        if (delayMin >= 0L) {
            this.mDelayMin = delayMin;
        }
        if (this.mDelayMin > this.mDelayMax) {
            this.mDelayMax = this.mDelayMin;
        }
    }

    public long getDelayMax() {
        return this.mDelayMax;
    }

    public void setDelayMax(long delayMax) {
        if (delayMax >= 0L) {
            this.mDelayMax = delayMax;
        }
        if (this.mDelayMax < this.mDelayMin) {
            this.mDelayMin = this.mDelayMax;
        }
    }
}

