/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.mock;

import android.content.Context;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.network.NetworkResponse;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.network.mock.MockApiNetworkResponse;
import com.shopgun.android.sdk.network.mock.MockNetwork;
import com.shopgun.android.sdk.network.mock.MockUnsupportedNetworkResponse;
import com.shopgun.android.sdk.network.mock.PathHelper;
import java.net.MalformedURLException;
import java.net.URL;

public class MockApiNetwork
extends MockNetwork {
    public static final String TAG = Constants.getTag(MockApiNetwork.class);
    Context mContext;

    public MockApiNetwork(Context ctx) {
        this.mContext = ctx;
    }

    @Override
    public NetworkResponse performRequest(Request<?> request) throws ShopGunError {
        super.performRequest(request);
        try {
            URL url = new URL(request.getUrl());
            if (!url.getHost().contains("etilbudsavis")) {
                throw new ShopGunError(Integer.MAX_VALUE, "Host not supported", url.getHost());
            }
            PathHelper pathHelper = new PathHelper(request);
            String apiVersion = pathHelper.getApiVersion();
            if (!"v2".equals(apiVersion)) {
                throw new ShopGunError(Integer.MAX_VALUE, "API version not supported", "Api version given: " + apiVersion);
            }
            return MockApiNetworkResponse.create(this.mContext, request, pathHelper.getType()).getResponse();
        }
        catch (MalformedURLException e) {
            return new MockUnsupportedNetworkResponse(request);
        }
    }
}

