/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.mock;

import android.content.Context;
import com.shopgun.android.sdk.network.NetworkResponse;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.mock.MockApiNetworkResponse;
import org.json.JSONArray;

public class MockApiCatalogResponse
extends MockApiNetworkResponse {
    protected MockApiCatalogResponse(Context mContext, Request<?> request) {
        super(mContext, request);
    }

    @Override
    public NetworkResponse getResponse() {
        JSONArray array = this.getAssetJSONArray("list-catalog.json");
        String actionOrId = this.mPath.getActionOrId();
        if (actionOrId == null) {
            JSONArray idArray = MockApiCatalogResponse.filterByIds(array, this.mRequest, "catalog_ids");
            if (idArray != null) {
                array = MockApiCatalogResponse.trimToOffsetAndLimit(idArray, this.mRequest);
                return new NetworkResponse(200, array.toString().getBytes(), null);
            }
            array = MockApiCatalogResponse.trimToOffsetAndLimit(array, this.mRequest);
            return new NetworkResponse(200, array.toString().getBytes(), null);
        }
        if ("search".equals(actionOrId)) {
            array = MockApiCatalogResponse.trimToOffsetAndLimit(array, this.mRequest);
            return new NetworkResponse(200, array.toString().getBytes(), null);
        }
        if ("suggest".equals(actionOrId)) {
            return new NetworkResponse(200, array.toString().getBytes(), null);
        }
        if ("count".equals(actionOrId)) {
            return this.getUnsupportedResponse();
        }
        if ("typeahead".equals(actionOrId)) {
            return new NetworkResponse(200, this.getAssetAsString("typeahead.json").getBytes(), null);
        }
        String id = actionOrId;
        String action = this.mPath.getItemAction();
        if (action == null) {
            return this.getItem(array, id);
        }
        if ("pages".equals(action)) {
            String name = String.format("catalog-%s-pages.json", id);
            JSONArray pages = this.getAssetJSONArray(name);
            return new NetworkResponse(200, pages.toString().getBytes(), null);
        }
        if ("hotspots".equals(action)) {
            String name = String.format("catalog-%s-hotspots.json", id);
            JSONArray hotspots = this.getAssetJSONArray(name);
            return new NetworkResponse(200, hotspots.toString().getBytes(), null);
        }
        if ("stores".equals(action)) {
            return this.getUnsupportedResponse();
        }
        if ("collect".equals(action)) {
            return new NetworkResponse(201, "{}".getBytes(), null);
        }
        if ("download".equals(action)) {
            return this.getUnsupportedResponse();
        }
        return this.getUnsupportedResponse();
    }
}

