/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.impl;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;
import java.io.UnsupportedEncodingException;

public abstract class JsonRequest<T>
extends Request<T> {
    public static final String TAG = Constants.getTag(JsonRequest.class);
    private static final String PROTOCOL_CONTENT_TYPE = String.format("application/json; charset=%s", "utf-8");
    private String mRequestBody;
    private Request.Priority mPriority = Request.Priority.MEDIUM;

    public JsonRequest(String url, Response.Listener<T> listener) {
        super(Request.Method.GET, url, listener);
    }

    public JsonRequest(Request.Method method, String url, String requestBody, Response.Listener<T> listener) {
        super(method, url, listener);
        boolean nonBodyRequest;
        boolean bl = nonBodyRequest = method == Request.Method.GET || method == Request.Method.DELETE;
        if (nonBodyRequest && requestBody != null) {
            SgnLog.i(TAG, "GET and DELETE requests doesn't take a body, and will be ignored.\nPlease append any GET and DELETE parameters to Request.putQueryParameters()");
        }
        this.mRequestBody = requestBody;
    }

    @Override
    public String getBodyContentType() {
        return PROTOCOL_CONTENT_TYPE;
    }

    @Override
    public byte[] getBody() {
        try {
            return this.mRequestBody == null ? null : this.mRequestBody.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    public Request<T> setPriority(Request.Priority p) {
        this.mPriority = p;
        return this;
    }

    @Override
    public Request.Priority getPriority() {
        return this.mPriority;
    }

    @Override
    public String toString() {
        if (this.mRequestBody != null) {
            return super.toString() + "&body=[" + this.mRequestBody + "]";
        }
        return super.toString();
    }
}

