/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.impl;

import android.text.TextUtils;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.utils.Utils;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonCacheHelper {
    public static final String TAG = Constants.getTag(JsonCacheHelper.class);
    private static final String ERN_FORMAT = "ern:%s:%s";
    private static Set<String> mErnTypes = new HashSet<String>();

    public static Response<JSONArray> getJSONArray(Request<?> r, Cache c) {
        Set<String> keys;
        boolean hasFilter;
        LinkedList cacheListLinkedList;
        JSONArray jArray = new JSONArray();
        Cache.Item cacheList = c.get(Utils.requestToUrlAndQueryString(r));
        if (cacheList != null && cacheList.object instanceof LinkedList && !(cacheListLinkedList = (LinkedList)cacheList.object).isEmpty() && cacheListLinkedList.get(0) instanceof String) {
            LinkedList erns = cacheListLinkedList;
            for (String string : erns) {
                Cache.Item jObject = c.get(string);
                if (jObject == null || !(jObject.object instanceof JSONObject)) continue;
                jArray.put(jObject.object);
            }
            if (jArray.length() == erns.size()) {
                return Response.fromSuccess(jArray, null);
            }
        }
        boolean bl = hasFilter = (keys = r.getParameters().keySet()).contains("catalog_ids") || keys.contains("dealer_ids") || keys.contains("offer_ids") || keys.contains("store_ids");
        if (!hasFilter) {
            return null;
        }
        String[] path = r.getUrl().split("/");
        String type = path[path.length - 1];
        Set<String> ids = JsonCacheHelper.getIdsFromFilter(type, r.getParameters());
        if (ids.size() == 0) {
            return null;
        }
        for (String id : ids) {
            String ern = JsonCacheHelper.buildErn(type, id);
            Cache.Item cacheId = c.get(ern);
            if (cacheId == null) continue;
            jArray.put(cacheId.object);
        }
        if (jArray.length() == ids.size()) {
            return Response.fromSuccess(jArray, null);
        }
        return null;
    }

    public static Response<JSONObject> getJSONObject(Request<?> r, Cache cache) {
        String id;
        String url = r.getUrl();
        String[] path = url.split("/");
        String type = path[path.length - 2];
        String ern = JsonCacheHelper.buildErn(type, id = path[path.length - 1]);
        Cache.Item ci = cache.get(ern);
        if (ci != null && ci.object instanceof JSONObject) {
            return Response.fromSuccess((JSONObject)ci.object, null);
        }
        return null;
    }

    public static void cacheJSONArray(Request<?> r, JSONArray a) {
        LinkedList<String> ernlist = new LinkedList<String>();
        try {
            for (int i = 0; i < a.length(); ++i) {
                String ern;
                Object o = a.get(i);
                if (!(o instanceof JSONObject) || (ern = JsonCacheHelper.cacheJSONObject(r, (JSONObject)o)) == null) continue;
                ernlist.add(ern);
            }
        }
        catch (JSONException e) {
            SgnLog.e(TAG, "", e);
        }
        if (ernlist.isEmpty()) {
            return;
        }
        r.getCache().put(Utils.requestToUrlAndQueryString(r), new Cache.Item(ernlist, r.getCacheTTL()));
    }

    public static String cacheJSONObject(Request<?> r, JSONObject o) {
        try {
            if (o.has("ern")) {
                String ern = o.getString("ern");
                Cache.Item i = new Cache.Item(o, r.getCacheTTL());
                r.getCache().put(ern, i);
                return ern;
            }
        }
        catch (JSONException e) {
            SgnLog.e(TAG, "", e);
        }
        return null;
    }

    private static Set<String> getIdsFromFilter(String filterName, Map<String, String> apiParams) {
        String tmp = apiParams.get(filterName);
        HashSet<String> list = new HashSet<String>();
        if (tmp != null) {
            Collections.addAll(list, TextUtils.split((String)tmp, (String)","));
        }
        return list;
    }

    private static String buildErn(String type, String id) {
        if (mErnTypes.contains(type)) {
            type = type.substring(0, type.length() - 1);
            return String.format(ERN_FORMAT, type, id);
        }
        return type;
    }

    static {
        mErnTypes.add("catalogs");
        mErnTypes.add("offers");
        mErnTypes.add("dealers");
        mErnTypes.add("stores");
        mErnTypes.add("shoppinglists");
        mErnTypes.add("items");
    }
}

