/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.impl;

import com.shopgun.android.sdk.network.RedirectProtocol;
import com.shopgun.android.sdk.network.Request;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class DefaultRedirectProtocol
implements RedirectProtocol {
    private String getFirstHeader(Map<String, List<String>> headers, String header) {
        if (headers.containsKey(header)) {
            return headers.get(header).get(0);
        }
        return null;
    }

    @Override
    public boolean isRedirectRequested(Request<?> request, HttpResponse response, ArrayList<URL> previouslyVisited) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 301 || statusCode == 302 || statusCode == 303) {
            request.addEvent("request-redirected-statuscode-" + statusCode);
            return true;
        }
        return false;
    }

    @Override
    public URL getRedirectLocation(Request<?> request, HttpResponse response, ArrayList<URL> previouslyVisited) throws IOException {
        URL url = previouslyVisited.get(previouslyVisited.size() - 1);
        Header locationHeader = response.getFirstHeader("Location");
        String location = null;
        if (locationHeader != null && !(location = locationHeader.getValue()).startsWith("http")) {
            location = url.getProtocol() + "://" + url.getHost() + location;
        }
        if (location != null) {
            URL redirectUrl = new URL(location);
            if (this.isInfiniteLoop(previouslyVisited, redirectUrl)) {
                request.addEvent("infinite-number-of-redirects-detected");
                return null;
            }
            request.addEvent("redirecting-request: " + location);
            return redirectUrl;
        }
        request.addEvent("no-location-header-identified");
        return null;
    }

    @Override
    public void onRedirectComplete(Request<?> request, ArrayList<URL> previouslyVisited) throws IOException {
    }

    protected boolean isInfiniteLoop(ArrayList<URL> previouslyVisited, URL redirectUrl) {
        for (int i = 0; i < previouslyVisited.size(); ++i) {
            URL outer = previouslyVisited.get(i);
            for (int j = i + 1; j < previouslyVisited.size(); ++j) {
                URL inner = previouslyVisited.get(j);
                if (!outer.equals(inner)) continue;
                return true;
            }
            if (!outer.equals(redirectUrl)) continue;
            return true;
        }
        return false;
    }
}

