/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.impl;

import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.NetworkResponse;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.utils.Utils;

public class ByteRequest
extends Request<byte[]> {
    private byte[] mRequestBody;
    private String mProtocolContentType;
    private Request.Priority mPriority = Request.Priority.MEDIUM;

    public ByteRequest(String url, Response.Listener<byte[]> listener) {
        super(Request.Method.GET, url, listener);
    }

    public ByteRequest(Request.Method method, String url, Response.Listener<byte[]> listener) {
        super(method, url, listener);
    }

    @Override
    public String getBodyContentType() {
        return this.mProtocolContentType;
    }

    public String setBodyContentType(String bodyContentType) {
        this.mProtocolContentType = bodyContentType;
        return this.mProtocolContentType;
    }

    @Override
    public byte[] getBody() {
        return this.mRequestBody;
    }

    public ByteRequest setBody(byte[] body) {
        this.mRequestBody = body;
        return this;
    }

    @Override
    public Request.Priority getPriority() {
        return this.mPriority;
    }

    public ByteRequest setPriority(Request.Priority p) {
        this.mPriority = p;
        return this;
    }

    @Override
    protected Response<byte[]> parseNetworkResponse(NetworkResponse response) {
        String url = Utils.requestToUrlAndQueryString(this);
        Cache.Item c = new Cache.Item(response.data, this.getCacheTTL());
        this.getCache().put(url, c);
        return Response.fromSuccess(response.data, this.getCache());
    }

    @Override
    protected Response<byte[]> parseCache(Cache c) {
        String url = Utils.requestToUrlAndQueryString(this);
        Cache.Item ci = c.get(url);
        if (ci != null && ci.object instanceof byte[]) {
            return Response.fromSuccess((byte[])ci.object, null);
        }
        return null;
    }
}

