/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network;

import android.os.Process;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.SessionManager;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.Delivery;
import com.shopgun.android.sdk.network.Network;
import com.shopgun.android.sdk.network.NetworkResponse;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.RequestQueue;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.utils.HashUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.json.JSONException;
import org.json.JSONObject;

public class NetworkDispatcher
extends Thread {
    public static final String TAG = Constants.getTag(NetworkDispatcher.class);
    private final ShopGun mShopGun;
    private final BlockingQueue<Request<?>> mQueue;
    private final RequestQueue mRequestQueue;
    private final Network mNetwork;
    private final Cache mCache;
    private final Delivery mDelivery;
    private volatile boolean mQuit = false;

    public NetworkDispatcher(ShopGun shopGun, RequestQueue requestQueue, BlockingQueue<Request<?>> queue, Network network, Cache cache, Delivery delivery) {
        this.mQueue = queue;
        this.mNetwork = network;
        this.mCache = cache;
        this.mDelivery = delivery;
        this.mRequestQueue = requestQueue;
        this.mShopGun = shopGun;
    }

    public void quit() {
        this.mQuit = true;
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        while (true) {
            Request<?> request;
            try {
                request = this.mQueue.take();
            }
            catch (InterruptedException e) {
                if (!this.mQuit) continue;
                return;
            }
            try {
                if (request.isCanceled()) {
                    request.finish("network-dispatcher-cancelled-on-recieved");
                    continue;
                }
                request.addEvent("recieved-by-network-dispatcher");
                this.prepare(request);
                NetworkResponse networkResponse = this.mNetwork.performRequest(request);
                this.appendLogging(request, networkResponse);
                request.addEvent("parsing-network-response");
                Response<?> response = request.parseNetworkResponse(networkResponse);
                if (response.isSuccess()) {
                    this.updateSessionInfo(networkResponse.headers);
                    this.mCache.put(request, response);
                    this.mDelivery.postResponse(request, response);
                    continue;
                }
                if (SessionManager.recoverableError(response.error)) {
                    request.addEvent("recoverable-session-error");
                    if (this.isSessionEndpoint(request)) {
                        this.mDelivery.postResponse(request, response);
                        continue;
                    }
                    if (this.mShopGun.getSessionManager().recover(response.error)) {
                        this.mRequestQueue.add(request);
                        continue;
                    }
                    this.mDelivery.postResponse(request, response);
                    continue;
                }
                request.addEvent("non-recoverable-error");
                this.mDelivery.postResponse(request, response);
                continue;
            }
            catch (ShopGunError e) {
                request.addEvent("network-error");
                this.mDelivery.postResponse(request, Response.fromError(e));
                continue;
            }
            break;
        }
    }

    private boolean isSessionEndpoint(Request<?> request) {
        return request.getUrl().contains("/v2/sessions");
    }

    private void prepare(Request<?> request) {
        boolean newSession;
        request.addEvent("preparing-headers");
        boolean bl = newSession = request.getMethod() == Request.Method.POST && request.getUrl().contains("/v2/sessions");
        if (!newSession) {
            HashMap<String, String> headers = new HashMap<String, String>();
            String token = this.mShopGun.getSessionManager().getSession().getToken();
            headers.put("X-Token", token);
            String sha256 = HashUtils.sha256(this.mShopGun.getApiSecret() + token);
            headers.put("X-Signature", sha256);
            request.setHeaders(headers);
        }
    }

    private void appendLogging(Request<?> req, NetworkResponse resp) {
        try {
            JSONObject r = new JSONObject();
            r.put("statuscode", resp.statusCode);
            if (resp.headers != null) {
                r.put("headers", (Object)new JSONObject(resp.headers));
            }
            req.getNetworkLog().put("response", (Object)r);
        }
        catch (JSONException e) {
            SgnLog.e(TAG, "", e);
        }
    }

    private void updateSessionInfo(Map<String, String> headers) {
        if (headers != null) {
            String token = headers.get("X-Token");
            String expire = headers.get("X-Token-Expires");
            if (token != null && expire != null) {
                this.mShopGun.getSessionManager().updateTokens(token, expire);
            }
        }
    }
}

