/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network;

import android.os.Process;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.Delivery;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;
import java.util.concurrent.BlockingQueue;

public class CacheDispatcher
extends Thread {
    public static final String TAG = Constants.getTag(CacheDispatcher.class);
    private final BlockingQueue<Request<?>> mQueue;
    private final BlockingQueue<Request<?>> mNetworkQueue;
    private final Cache mCache;
    private final Delivery mDelivery;
    private volatile boolean mQuit = false;

    public CacheDispatcher(BlockingQueue<Request<?>> cacheQueue, BlockingQueue<Request<?>> networkQueue, Cache cache, Delivery delivery) {
        this.mQueue = cacheQueue;
        this.mNetworkQueue = networkQueue;
        this.mCache = cache;
        this.mDelivery = delivery;
    }

    public void quit() {
        this.mQuit = true;
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        while (true) {
            Response<?> response;
            Request<?> request;
            try {
                request = this.mQueue.take();
            }
            catch (InterruptedException e) {
                if (!this.mQuit) continue;
                return;
            }
            if (request.isCanceled()) {
                request.finish("cache-dispatcher-cancelled-on-received");
                continue;
            }
            request.addEvent("received-by-cache-dispatcher");
            if (!request.ignoreCache() && (response = request.parseCache(this.mCache)) != null) {
                request.addEvent("post-cache-item");
                request.setCacheHit(true);
                this.mDelivery.postResponse(request, response);
                continue;
            }
            request.addEvent("add-to-network-queue");
            this.mNetworkQueue.add(request);
        }
    }
}

