/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.Dealer;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.SgnJson;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Subscription
implements IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Subscription.class);
    public static Parcelable.Creator<Subscription> CREATOR = new Parcelable.Creator<Subscription>(){

        public Subscription createFromParcel(Parcel source) {
            return new Subscription(source);
        }

        public Subscription[] newArray(int size) {
            return new Subscription[size];
        }
    };
    private Dealer mDealer;
    public static Comparator<Subscription> DEALER_NAME_COMPARATOR = new Comparator<Subscription>(){

        @Override
        public int compare(Subscription item1, Subscription item2) {
            if (item1 == null || item2 == null) {
                return item1 == null ? (item2 == null ? 0 : 1) : -1;
            }
            Dealer d1 = item1.getDealer();
            Dealer d2 = item2.getDealer();
            if (d1 == null || d2 == null) {
                return d1 == null ? (d2 == null ? 0 : 1) : -1;
            }
            String t1 = d1.getName();
            String t2 = d2.getName();
            if (t1 == null || t2 == null) {
                return t1 == null ? (t2 == null ? 0 : 1) : -1;
            }
            return t1.compareToIgnoreCase(t2);
        }
    };
    private String mDealerId;
    private boolean mSubscribed = false;

    private Subscription() {
    }

    public Subscription(Subscription s) {
        this.setDealer(s.getDealer());
        this.setDealerId(s.getDealerId());
        this.setSubscribed(s.isSubscribed());
    }

    public Subscription(Dealer d) {
        this.setDealer(d);
    }

    public Subscription(String dealerId) {
        this.setDealerId(dealerId);
    }

    private Subscription(Parcel in) {
        this.mDealer = (Dealer)in.readParcelable(Dealer.class.getClassLoader());
        this.mDealerId = in.readString();
        this.mSubscribed = in.readByte() != 0;
    }

    public static List<Subscription> fromJSON(JSONArray array) {
        ArrayList<Subscription> list = new ArrayList<Subscription>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Subscription.fromJSON(o));
        }
        return list;
    }

    public static Subscription fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Subscription s = new Subscription().setDealerId(o.getDealerId()).setSubscribed(o.getSubscribed()).setDealer(o.getDealer());
        o.getStats().ignoreRejectedKeys("dealer").log(TAG);
        return s;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setDealerId(this.getDealerId()).setSubscribed(this.isSubscribed()).putDealer(this.getDealer()).toJSON();
    }

    public Dealer getDealer() {
        return this.mDealer;
    }

    public Subscription setDealer(Dealer d) {
        this.mDealer = d;
        if (this.mDealer != null) {
            this.setDealerId(this.mDealer.getId());
        }
        return this;
    }

    public String getDealerId() {
        return this.mDealerId;
    }

    public Subscription setDealerId(String dealerId) {
        this.mDealerId = dealerId;
        if (this.mDealer != null && !this.mDealer.getId().equals(this.mDealerId)) {
            this.setDealer(null);
        }
        return this;
    }

    public boolean isSubscribed() {
        return this.mSubscribed;
    }

    public Subscription setSubscribed(boolean subscribed) {
        this.mSubscribed = subscribed;
        return this;
    }

    public void toggle() {
        this.mSubscribed = !this.mSubscribed;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mDealer == null ? 0 : this.mDealer.hashCode());
        result = 31 * result + (this.mDealerId == null ? 0 : this.mDealerId.hashCode());
        result = 31 * result + (this.mSubscribed ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Subscription other = (Subscription)obj;
        if (this.mDealer == null ? other.mDealer != null : !this.mDealer.equals(other.mDealer)) {
            return false;
        }
        if (this.mDealerId == null ? other.mDealerId != null : !this.mDealerId.equals(other.mDealerId)) {
            return false;
        }
        return this.mSubscribed == other.mSubscribed;
    }

    public String toString() {
        JSONObject o = this.toJSON();
        if (this.mDealer != null) {
            try {
                o.remove("dealer");
                o.put("dealer", (Object)this.mDealer.getName());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return o.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.mDealer, flags);
        dest.writeString(this.mDealerId);
        dest.writeByte(this.mSubscribed ? (byte)1 : 0);
    }
}

