/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Branding;
import com.shopgun.android.sdk.model.Country;
import com.shopgun.android.sdk.model.Dealer;
import com.shopgun.android.sdk.model.interfaces.IDealer;
import com.shopgun.android.sdk.model.interfaces.IErn;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.SgnJson;
import com.shopgun.android.sdk.utils.Utils;
import java.util.ArrayList;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Store
implements IErn<Store>,
IJson<JSONObject>,
IDealer<Store>,
Parcelable {
    public static final String TAG = Constants.getTag(Store.class);
    private String mErn;
    private String mStreet;
    private String mCity;
    private String mZipcode;
    private Country mCountry;
    private double mLatitude = 0.0;
    private double mLongitude = 0.0;
    private String mDealerUrl;
    private String mDealerId;
    private Branding mBranding;
    private String mContact;
    private Dealer mDealer;
    private Set<String> mCategoryIds;
    public static final Parcelable.Creator<Store> CREATOR = new Parcelable.Creator<Store>(){

        public Store createFromParcel(Parcel source) {
            return new Store(source);
        }

        public Store[] newArray(int size) {
            return new Store[size];
        }
    };

    public Store() {
    }

    public Store(Store store) {
        Store tmp = Utils.copyParcelable(store, CREATOR);
        this.mErn = tmp.mErn;
        this.mStreet = tmp.mStreet;
        this.mCity = tmp.mCity;
        this.mZipcode = tmp.mZipcode;
        this.mCountry = tmp.mCountry;
        this.mLatitude = tmp.mLatitude;
        this.mLongitude = tmp.mLongitude;
        this.mDealerUrl = tmp.mDealerUrl;
        this.mDealerId = tmp.mDealerId;
        this.mBranding = tmp.mBranding;
        this.mContact = tmp.mContact;
        this.mDealer = tmp.mDealer;
        this.mCategoryIds = tmp.mCategoryIds;
    }

    public static ArrayList<Store> fromJSON(JSONArray array) {
        ArrayList<Store> list = new ArrayList<Store>();
        try {
            for (int i = 0; i < array.length(); ++i) {
                list.add(Store.fromJSON((JSONObject)array.get(i)));
            }
        }
        catch (JSONException e) {
            SgnLog.e(TAG, "", e);
        }
        return list;
    }

    public static Store fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        o.isErnTypeOrThrow("store", Store.class);
        Store s = new Store().setId(o.getId()).setErn(o.getErn()).setStreet(o.getStreet()).setCity(o.getCity()).setZipcode(o.getZipCode()).setCountry(o.getCountry()).setLatitude(o.getLatitude()).setLongitude(o.getLongitude()).setDealerUrl(o.getDealerUrl()).setDealerId(o.getDealerId()).setBranding(o.getBranding()).setContact(o.getContact()).setCategoryIds(o.getCategoryIds());
        s.mDealer = o.getDealer();
        o.getStats().ignoreForgottenKeys("youtube_user_id", "twitter_handle", "facebook_page_id").ignoreRejectedKeys("dealer").log(TAG);
        return s;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setId(this.getId()).setErn(this.getErn()).setStreet(this.getStreet()).setCity(this.getCity()).setZipCode(this.getZipcode()).setCountry(this.getCountry()).setLatitude(this.getLatitude()).setLongitude(this.getLongitude()).setDealerUrl(this.getDealerUrl()).setDealerId(this.getDealerId()).setBranding(this.getBranding()).setContact(this.getContact()).setCategoryIds(this.getCategoryIds()).putDealer(this.getDealer()).toJSON();
    }

    @Override
    public String getId() {
        if (this.mErn == null) {
            return null;
        }
        String[] parts = this.mErn.split(":");
        return parts[parts.length - 1];
    }

    @Override
    public Store setId(String id) {
        this.setErn(id == null ? null : String.format("ern:%s:%s", this.getErnType(), id));
        return this;
    }

    @Override
    public String getErn() {
        return this.mErn;
    }

    @Override
    public Store setErn(String ern) {
        if (ern == null || ern.startsWith("ern:") && ern.split(":").length == 3 && ern.contains(this.getErnType())) {
            this.mErn = ern;
        }
        return this;
    }

    @Override
    public String getErnType() {
        return "store";
    }

    public String getStreet() {
        return this.mStreet;
    }

    public Store setStreet(String street) {
        this.mStreet = street;
        return this;
    }

    public String getCity() {
        return this.mCity;
    }

    public Store setCity(String city) {
        this.mCity = city;
        return this;
    }

    public String getZipcode() {
        return this.mZipcode;
    }

    public Store setZipcode(String zipcode) {
        this.mZipcode = zipcode;
        return this;
    }

    public Country getCountry() {
        return this.mCountry;
    }

    public Store setCountry(Country country) {
        this.mCountry = country;
        return this;
    }

    public Double getLatitude() {
        return this.mLatitude;
    }

    public Store setLatitude(Double latitude) {
        this.mLatitude = latitude;
        return this;
    }

    public Double getLongitude() {
        return this.mLongitude;
    }

    public Store setLongitude(Double longitude) {
        this.mLongitude = longitude;
        return this;
    }

    public String getDealerUrl() {
        return this.mDealerUrl;
    }

    public Store setDealerUrl(String url) {
        this.mDealerUrl = url;
        return this;
    }

    @Override
    public String getDealerId() {
        return this.mDealerId;
    }

    public Store setDealerId(String dealerId) {
        this.mDealerId = dealerId;
        if (this.mDealerId == null) {
            this.mDealer = null;
        } else if (this.mDealer != null && !this.mDealerId.equals(this.mDealer.getId())) {
            this.mDealer = null;
        }
        return this;
    }

    public Branding getBranding() {
        return this.mBranding;
    }

    public Store setBranding(Branding branding) {
        this.mBranding = branding;
        return this;
    }

    public String getContact() {
        return this.mContact;
    }

    public Store setContact(String contact) {
        this.mContact = contact;
        return this;
    }

    @Override
    public Dealer getDealer() {
        return this.mDealer;
    }

    @Override
    public Store setDealer(Dealer dealer) {
        this.mDealer = dealer;
        this.mDealerId = this.mDealer == null ? null : this.mDealer.getId();
        return this;
    }

    public Set<String> getCategoryIds() {
        return this.mCategoryIds;
    }

    public Store setCategoryIds(Set<String> categoryIds) {
        this.mCategoryIds = categoryIds;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Store store = (Store)o;
        if (Double.compare(store.mLatitude, this.mLatitude) != 0) {
            return false;
        }
        if (Double.compare(store.mLongitude, this.mLongitude) != 0) {
            return false;
        }
        if (this.mErn != null ? !this.mErn.equals(store.mErn) : store.mErn != null) {
            return false;
        }
        if (this.mStreet != null ? !this.mStreet.equals(store.mStreet) : store.mStreet != null) {
            return false;
        }
        if (this.mCity != null ? !this.mCity.equals(store.mCity) : store.mCity != null) {
            return false;
        }
        if (this.mZipcode != null ? !this.mZipcode.equals(store.mZipcode) : store.mZipcode != null) {
            return false;
        }
        if (this.mCountry != null ? !this.mCountry.equals(store.mCountry) : store.mCountry != null) {
            return false;
        }
        if (this.mDealerUrl != null ? !this.mDealerUrl.equals(store.mDealerUrl) : store.mDealerUrl != null) {
            return false;
        }
        if (this.mDealerId != null ? !this.mDealerId.equals(store.mDealerId) : store.mDealerId != null) {
            return false;
        }
        if (this.mBranding != null ? !this.mBranding.equals(store.mBranding) : store.mBranding != null) {
            return false;
        }
        if (this.mContact != null ? !this.mContact.equals(store.mContact) : store.mContact != null) {
            return false;
        }
        return this.mDealer != null ? this.mDealer.equals(store.mDealer) : store.mDealer == null;
    }

    public int hashCode() {
        int result = this.mErn != null ? this.mErn.hashCode() : 0;
        result = 31 * result + (this.mStreet != null ? this.mStreet.hashCode() : 0);
        result = 31 * result + (this.mCity != null ? this.mCity.hashCode() : 0);
        result = 31 * result + (this.mZipcode != null ? this.mZipcode.hashCode() : 0);
        result = 31 * result + (this.mCountry != null ? this.mCountry.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.mLatitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mLongitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.mDealerUrl != null ? this.mDealerUrl.hashCode() : 0);
        result = 31 * result + (this.mDealerId != null ? this.mDealerId.hashCode() : 0);
        result = 31 * result + (this.mBranding != null ? this.mBranding.hashCode() : 0);
        result = 31 * result + (this.mContact != null ? this.mContact.hashCode() : 0);
        result = 31 * result + (this.mDealer != null ? this.mDealer.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mErn);
        dest.writeString(this.mStreet);
        dest.writeString(this.mCity);
        dest.writeString(this.mZipcode);
        dest.writeParcelable((Parcelable)this.mCountry, 0);
        dest.writeDouble(this.mLatitude);
        dest.writeDouble(this.mLongitude);
        dest.writeString(this.mDealerUrl);
        dest.writeString(this.mDealerId);
        dest.writeParcelable((Parcelable)this.mBranding, 0);
        dest.writeString(this.mContact);
        dest.writeParcelable((Parcelable)this.mDealer, 0);
    }

    protected Store(Parcel in) {
        this.mErn = in.readString();
        this.mStreet = in.readString();
        this.mCity = in.readString();
        this.mZipcode = in.readString();
        this.mCountry = (Country)in.readParcelable(Country.class.getClassLoader());
        this.mLatitude = in.readDouble();
        this.mLongitude = in.readDouble();
        this.mDealerUrl = in.readString();
        this.mDealerId = in.readString();
        this.mBranding = (Branding)in.readParcelable(Branding.class.getClassLoader());
        this.mContact = in.readString();
        this.mDealer = (Dealer)in.readParcelable(Dealer.class.getClassLoader());
    }
}

