/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.SgnJson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Si
implements IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Si.class);
    public static Parcelable.Creator<Si> CREATOR = new Parcelable.Creator<Si>(){

        public Si createFromParcel(Parcel source) {
            return new Si(source);
        }

        public Si[] newArray(int size) {
            return new Si[size];
        }
    };
    private String mSymbol;
    private double mFactor = 1.0;

    public Si() {
    }

    private Si(Parcel in) {
        this.mSymbol = in.readString();
        this.mFactor = in.readDouble();
    }

    public static List<Si> fromJSON(JSONArray array) {
        ArrayList<Si> list = new ArrayList<Si>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Si.fromJSON(o));
        }
        return list;
    }

    public static Si fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Si s = new Si().setSymbol(o.getSymbol()).setFactor(o.getFactor());
        o.getStats().log(TAG);
        return s;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setSymbol(this.getSymbol()).setFactor(this.getFactor()).toJSON();
    }

    public String getSymbol() {
        return this.mSymbol;
    }

    public Si setSymbol(String symbol) {
        this.mSymbol = symbol;
        return this;
    }

    public double getFactor() {
        return this.mFactor;
    }

    public Si setFactor(double factor) {
        this.mFactor = factor;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.mFactor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.mSymbol == null ? 0 : this.mSymbol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Si other = (Si)obj;
        if (Double.doubleToLongBits(this.mFactor) != Double.doubleToLongBits(other.mFactor)) {
            return false;
        }
        return !(this.mSymbol == null ? other.mSymbol != null : !this.mSymbol.equals(other.mSymbol));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mSymbol);
        dest.writeDouble(this.mFactor);
    }
}

