/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.Share;
import com.shopgun.android.sdk.model.interfaces.IErn;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.model.interfaces.SyncState;
import com.shopgun.android.sdk.utils.SgnJson;
import com.shopgun.android.sdk.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Shoppinglist
implements Comparable<Shoppinglist>,
SyncState<Shoppinglist>,
IErn<Shoppinglist>,
IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Shoppinglist.class);
    public static final String TYPE_SHOPPING_LIST = "shopping_list";
    public static final String TYPE_WISH_LIST = "wish_list";
    public static final String ACCESS_PRIVATE = "private";
    public static final String ACCESS_SHARED = "shared";
    public static final String ACCESS_PUBLIC = "public";
    public static Parcelable.Creator<Shoppinglist> CREATOR = new Parcelable.Creator<Shoppinglist>(){

        public Shoppinglist createFromParcel(Parcel source) {
            return new Shoppinglist(source);
        }

        public Shoppinglist[] newArray(int size) {
            return new Shoppinglist[size];
        }
    };
    private String mErn;
    private String mName = "";
    public static Comparator<Shoppinglist> NAME_COMPARATOR = new Comparator<Shoppinglist>(){

        @Override
        public int compare(Shoppinglist item1, Shoppinglist item2) {
            if (item1 == null || item2 == null) {
                return item1 == null ? (item2 == null ? 0 : 1) : -1;
            }
            String t1 = item1.getName();
            String t2 = item2.getName();
            if (t1 == null || t2 == null) {
                return t1 == null ? (t2 == null ? 0 : 1) : -1;
            }
            return t1.compareToIgnoreCase(t2);
        }
    };
    private String mAccess = "private";
    private Date mModified;
    private String mPrevId;
    private String mType;
    private JSONObject mMeta;
    private HashMap<String, Share> mShares = new HashMap(1);
    private int mUserId = -1;
    private int mSyncState = 0;

    private Shoppinglist() {
        this.setId(Utils.createUUID());
        this.mModified = Utils.roundTime(new Date());
    }

    private Shoppinglist(Parcel in) {
        this.mErn = in.readString();
        this.mName = in.readString();
        this.mAccess = in.readString();
        long tmpMModified = in.readLong();
        this.mModified = tmpMModified == -1L ? null : new Date(tmpMModified);
        this.mPrevId = in.readString();
        this.mType = in.readString();
        try {
            String json = in.readString();
            this.mMeta = new JSONObject(json);
        }
        catch (JSONException e) {
            this.mMeta = new JSONObject();
        }
        ArrayList list = new ArrayList();
        in.readTypedList(list, Share.CREATOR);
        for (Share s : list) {
            this.mShares.put(s.getEmail(), s);
        }
        this.mUserId = in.readInt();
        this.mSyncState = in.readInt();
    }

    public static Shoppinglist fromName(String name) {
        Shoppinglist sl = new Shoppinglist();
        sl.setName(name);
        return sl;
    }

    public static ArrayList<Shoppinglist> fromJSON(JSONArray array) {
        ArrayList<Shoppinglist> list = new ArrayList<Shoppinglist>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Shoppinglist.fromJSON(o));
        }
        return list;
    }

    public static Shoppinglist fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Shoppinglist shoppinglist = new Shoppinglist().setId(o.getId()).setErn(o.getErn()).setName(o.getName()).setAccess(o.getAccess()).setModified(o.getModified()).setPreviousId(o.getPreviousId()).setType(o.getType()).setMeta(o.getMeta()).putShares(o.getShares());
        o.getStats().ignoreForgottenKeys("owner").ignoreRejectedKeys("previous_id").log(TAG);
        return shoppinglist;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setId(this.getId()).setErn(this.getErn()).setName(this.getName()).setAccess(this.getAccess()).setModified(this.getModified()).setPreviousId(this.getPreviousId()).setType(this.getType()).setMeta(this.getMeta()).setShares(this.getShares().values()).toJSON();
    }

    @Override
    public String getId() {
        if (this.mErn == null) {
            return null;
        }
        String[] parts = this.mErn.split(":");
        return parts[parts.length - 1];
    }

    @Override
    public Shoppinglist setId(String id) {
        this.setErn(id == null ? null : String.format("ern:%s:%s", this.getErnType(), id));
        return this;
    }

    @Override
    public String getErn() {
        return this.mErn;
    }

    @Override
    public Shoppinglist setErn(String ern) {
        if (ern == null || ern.startsWith("ern:") && ern.split(":").length == 4 && ern.contains(this.getErnType())) {
            this.mErn = ern;
        }
        return this;
    }

    @Override
    public String getErnType() {
        return "shopping:list";
    }

    public String getName() {
        return this.mName;
    }

    public Shoppinglist setName(String name) {
        this.mName = name;
        return this;
    }

    public String getAccess() {
        return this.mAccess;
    }

    public Shoppinglist setAccess(String access) {
        this.mAccess = access;
        return this;
    }

    public Date getModified() {
        return this.mModified;
    }

    public Shoppinglist setModified(Date time) {
        this.mModified = Utils.roundTime(time);
        return this;
    }

    public String getPreviousId() {
        return this.mPrevId;
    }

    public Shoppinglist setPreviousId(String id) {
        this.mPrevId = id;
        return this;
    }

    public String getType() {
        if (this.mType == null || this.mType.isEmpty()) {
            this.mType = TYPE_SHOPPING_LIST;
        }
        return this.mType;
    }

    public Shoppinglist setType(String type) {
        this.mType = type == null || type.isEmpty() ? TYPE_SHOPPING_LIST : type;
        return this;
    }

    public HashMap<String, Share> getShares() {
        return this.mShares;
    }

    public Shoppinglist setShares(List<Share> shares) {
        this.mShares.clear();
        for (Share s : shares) {
            s.setShoppinglistId(this.getId());
            this.mShares.put(s.getEmail(), s);
        }
        return this;
    }

    public Shoppinglist putShares(Collection<Share> shares) {
        if (shares == null) {
            return this;
        }
        for (Share s : shares) {
            s.setShoppinglistId(this.getId());
            this.mShares.put(s.getEmail(), s);
        }
        return this;
    }

    public Shoppinglist putShare(Share share) {
        if (share == null) {
            return this;
        }
        share.setShoppinglistId(this.getId());
        this.mShares.put(share.getEmail(), share);
        return this;
    }

    public Shoppinglist removeShare(Share s) {
        if (s == null) {
            return this;
        }
        this.mShares.remove(s.getEmail());
        return this;
    }

    public JSONObject getMeta() {
        if (this.mMeta == null) {
            this.mMeta = new JSONObject();
            this.setModified(new Date());
        }
        return this.mMeta;
    }

    public Shoppinglist setMeta(JSONObject meta) {
        this.mMeta = meta == null ? new JSONObject() : meta;
        return this;
    }

    public String getTheme() {
        return this.getMeta().optString("eta_theme", "default");
    }

    public Shoppinglist setTheme(String id) {
        try {
            this.getMeta().put("eta_theme", (Object)id);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public Share getOwner() {
        for (Share s : this.mShares.values()) {
            if (!s.getAccess().equals("owner")) continue;
            return s;
        }
        return null;
    }

    public int getUserId() {
        return this.mUserId;
    }

    public Shoppinglist setUserId(int userId) {
        this.mUserId = userId;
        return this;
    }

    @Override
    public int getState() {
        return this.mSyncState;
    }

    @Override
    public Shoppinglist setState(int state) {
        this.mSyncState = state;
        return this;
    }

    @Override
    public int compareTo(Shoppinglist another) {
        if (another == null) {
            return -1;
        }
        String t1 = this.getName();
        String t2 = another.getName();
        if (t1 == null || t2 == null) {
            return t1 == null ? (t2 == null ? 0 : 1) : -1;
        }
        return t1.compareToIgnoreCase(t2);
    }

    public boolean same(Object obj) {
        return this.compare(obj, false, false, false);
    }

    public boolean compare(Object obj, boolean modified, boolean syncState, boolean user) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Shoppinglist other = (Shoppinglist)obj;
        if (this.mAccess == null ? other.mAccess != null : !this.mAccess.equals(other.mAccess)) {
            return false;
        }
        if (this.mErn == null ? other.mErn != null : !this.mErn.equals(other.mErn)) {
            return false;
        }
        if (this.mMeta == null ? other.mMeta != null : !SgnJson.jsonObjectEquals(this.mMeta, other.mMeta)) {
            return false;
        }
        if (modified && (this.mModified == null ? other.mModified != null : !this.mModified.equals(other.mModified))) {
            return false;
        }
        if (this.mName == null ? other.mName != null : !this.mName.equals(other.mName)) {
            return false;
        }
        if (this.mPrevId == null ? other.mPrevId != null : !this.mPrevId.equals(other.mPrevId)) {
            return false;
        }
        if (this.mShares == null ? other.mShares != null : !this.mShares.equals(other.mShares)) {
            return false;
        }
        if (syncState && this.mSyncState != other.mSyncState) {
            return false;
        }
        if (this.mType == null ? other.mType != null : !this.mType.equals(other.mType)) {
            return false;
        }
        return !user || this.mUserId == other.mUserId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mAccess == null ? 0 : this.mAccess.hashCode());
        result = 31 * result + (this.mErn == null ? 0 : this.mErn.hashCode());
        result = 31 * result + SgnJson.jsonObjectHashCode(this.mMeta);
        result = 31 * result + (this.mModified == null ? 0 : this.mModified.hashCode());
        result = 31 * result + (this.mName == null ? 0 : this.mName.hashCode());
        result = 31 * result + (this.mPrevId == null ? 0 : this.mPrevId.hashCode());
        result = 31 * result + (this.mShares == null ? 0 : this.mShares.hashCode());
        result = 31 * result + this.mSyncState;
        result = 31 * result + (this.mType == null ? 0 : this.mType.hashCode());
        result = 31 * result + this.mUserId;
        return result;
    }

    public boolean equals(Object obj) {
        return this.compare(obj, true, true, true);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mErn);
        dest.writeString(this.mName);
        dest.writeString(this.mAccess);
        dest.writeLong(this.mModified != null ? this.mModified.getTime() : -1L);
        dest.writeString(this.mPrevId);
        dest.writeString(this.mType);
        dest.writeString(this.mMeta.toString());
        dest.writeTypedList(new ArrayList<Share>(this.mShares.values()));
        dest.writeInt(this.mUserId);
        dest.writeInt(this.mSyncState);
    }
}

