/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.palette.MaterialColor;
import com.shopgun.android.sdk.palette.SgnColor;
import com.shopgun.android.sdk.utils.SgnJson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Pageflip
implements IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Pageflip.class);
    private String mLogo;
    private MaterialColor mColor;
    public static final Parcelable.Creator<Pageflip> CREATOR = new Parcelable.Creator<Pageflip>(){

        public Pageflip createFromParcel(Parcel source) {
            return new Pageflip(source);
        }

        public Pageflip[] newArray(int size) {
            return new Pageflip[size];
        }
    };

    public Pageflip() {
    }

    public Pageflip(int color) {
        this.mColor = new SgnColor(color);
    }

    public static List<Pageflip> fromJSON(JSONArray array) {
        ArrayList<Pageflip> list = new ArrayList<Pageflip>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Pageflip.fromJSON(o));
        }
        return list;
    }

    public static Pageflip fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Pageflip p = new Pageflip().setLogo(o.getLogo()).setColor(o.getColor());
        o.getStats().log(TAG);
        return p;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setLogo(this.getLogo()).setColor(this.getColor()).toJSON();
    }

    public String getLogo() {
        return this.mLogo;
    }

    public Pageflip setLogo(String url) {
        this.mLogo = url;
        return this;
    }

    public int getColor() {
        return this.getMaterialColor().getValue();
    }

    public MaterialColor getMaterialColor() {
        if (this.mColor == null) {
            this.mColor = new SgnColor();
        }
        return this.mColor;
    }

    public Pageflip setColor(int color) {
        this.setColor(new SgnColor(color));
        return this;
    }

    public Pageflip setColor(MaterialColor color) {
        this.mColor = color;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pageflip pageflip = (Pageflip)o;
        if (this.mLogo != null ? !this.mLogo.equals(pageflip.mLogo) : pageflip.mLogo != null) {
            return false;
        }
        return !(this.mColor == null ? pageflip.mColor != null : !this.mColor.equals(pageflip.mColor));
    }

    public int hashCode() {
        int result = this.mLogo != null ? this.mLogo.hashCode() : 0;
        result = 31 * result + (this.mColor != null ? this.mColor.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mLogo);
        dest.writeParcelable((Parcelable)this.mColor, 0);
    }

    protected Pageflip(Parcel in) {
        this.mLogo = in.readString();
        this.mColor = (MaterialColor)in.readParcelable(MaterialColor.class.getClassLoader());
    }
}

