/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Dimension;
import com.shopgun.android.sdk.model.Offer;
import com.shopgun.android.sdk.model.interfaces.IJson;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Hotspot
implements IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Hotspot.class);
    public static final double SIGNIFICANT_AREA = 0.02;
    public static final double SIGNIFICANT_WH = 0.7;
    public static Parcelable.Creator<Hotspot> CREATOR = new Parcelable.Creator<Hotspot>(){

        public Hotspot createFromParcel(Parcel source) {
            return new Hotspot(source);
        }

        public Hotspot[] newArray(int size) {
            return new Hotspot[size];
        }
    };
    public double mTop = Double.MIN_VALUE;
    public double mBottom = Double.MIN_VALUE;
    public double mLeft = Double.MIN_VALUE;
    public double mRight = Double.MIN_VALUE;
    public double mAbsTop = Double.MIN_VALUE;
    public double mAbsBottom = Double.MIN_VALUE;
    public double mAbsLeft = Double.MIN_VALUE;
    public double mAbsRight = Double.MIN_VALUE;
    private String mType;
    private int mPage = 0;
    private Offer mOffer;
    private boolean mIsSpanningTwoPages = false;
    private int mColor = 0;

    public Hotspot() {
    }

    private Hotspot(Parcel in) {
        this.mPage = in.readInt();
        this.mOffer = (Offer)in.readParcelable(Offer.class.getClassLoader());
        this.mIsSpanningTwoPages = in.readByte() != 0;
        this.mTop = in.readDouble();
        this.mBottom = in.readDouble();
        this.mLeft = in.readDouble();
        this.mRight = in.readDouble();
        this.mAbsTop = in.readDouble();
        this.mAbsBottom = in.readDouble();
        this.mAbsLeft = in.readDouble();
        this.mAbsRight = in.readDouble();
        this.mColor = in.readInt();
    }

    public static Hotspot fromJSON(JSONArray jHotspot) {
        Hotspot h = new Hotspot();
        if (jHotspot == null) {
            return h;
        }
        if (jHotspot.length() != 4) {
            SgnLog.w(TAG, "Expected jHotspot.length == 4, actual length: " + jHotspot.length());
            return h;
        }
        for (int i = 0; i < jHotspot.length(); ++i) {
            try {
                JSONArray point = jHotspot.getJSONArray(i);
                if (point.length() != 2) {
                    SgnLog.w(TAG, "Expected hotspot.point.length == 2, actual length: " + point.length());
                    continue;
                }
                double x = Double.valueOf(point.getString(0));
                double y = Double.valueOf(point.getString(1));
                if (h.mAbsLeft == Double.MIN_VALUE) {
                    h.mAbsLeft = x;
                } else if (h.mAbsLeft > x) {
                    h.mAbsRight = h.mAbsLeft;
                    h.mAbsLeft = x;
                } else {
                    h.mAbsRight = x;
                }
                if (h.mAbsTop == Double.MIN_VALUE) {
                    h.mAbsTop = y;
                    continue;
                }
                if (h.mAbsTop > y) {
                    h.mAbsBottom = h.mAbsTop;
                    h.mAbsTop = y;
                    continue;
                }
                h.mAbsBottom = y;
                continue;
            }
            catch (JSONException e) {
                SgnLog.e(TAG, e.getMessage(), e);
            }
        }
        return h;
    }

    public void normalize(Dimension d) {
        this.mTop = this.mAbsTop / d.getHeight();
        this.mRight = this.mAbsRight / d.getWidth();
        this.mBottom = this.mAbsBottom / d.getHeight();
        this.mLeft = this.mAbsLeft / d.getWidth();
    }

    public boolean inBounds(double x, double y, double minArea, int[] pages) {
        return this.inBounds(x, y) && this.isAreaSignificant(pages);
    }

    public boolean inBounds(double x, double y) {
        return this.mTop < y && y < this.mBottom && this.mLeft < x && x < this.mRight;
    }

    public boolean isAreaSignificant(int[] pages) {
        return this.isAreaSignificant(0.02, 0.7, pages);
    }

    public boolean isAreaSignificant(double minArea, double minWH, int[] pages) {
        return pages.length != 1 || !this.mIsSpanningTwoPages || this.getArea() > minArea;
    }

    public double getArea() {
        return Math.abs(this.mTop - this.mBottom) * Math.abs(this.mLeft - this.mRight);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        try {
            o.put("left", this.mLeft);
            o.put("top", this.mTop);
            o.put("right", this.mRight);
            o.put("bottom", this.mBottom);
            String offer = this.mOffer == null ? "null" : this.mOffer.getHeading();
            o.put("offer", (Object)offer);
        }
        catch (JSONException e) {
            SgnLog.e(TAG, e.getMessage(), e);
        }
        return o;
    }

    public boolean isDualPage() {
        return this.mIsSpanningTwoPages;
    }

    public void setDualPage(boolean isDualPage) {
        this.mIsSpanningTwoPages = isDualPage;
    }

    public int getPage() {
        return this.mPage;
    }

    public void setPage(int page) {
        this.mPage = page;
    }

    public Offer getOffer() {
        return this.mOffer;
    }

    public void setOffer(Offer offer) {
        this.mOffer = offer;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int color) {
        this.mColor = color;
    }

    public Rect getRect(Bitmap b) {
        int left = (int)(this.mLeft * (double)b.getWidth());
        int top = (int)(this.mTop * (double)b.getHeight());
        int right = (int)(this.mRight * (double)b.getWidth());
        int bottom = (int)(this.mBottom * (double)b.getHeight());
        return new Rect(left, top, right, bottom);
    }

    public RectF getRectF(Bitmap b) {
        return new RectF(this.getRect(b));
    }

    public String toString() {
        String offer = this.mOffer == null ? "null" : this.mOffer.getHeading();
        String text = "hotspot[offer:%s, t:%.2f, r:%.2f, b:%.2f, l:%.2f, absT:%.2f, absR:%.2f, absB:%.2f, absL:%.2f]";
        return String.format(text, offer, this.mTop, this.mRight, this.mBottom, this.mLeft, this.mAbsTop, this.mAbsRight, this.mAbsBottom, this.mAbsLeft);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.mAbsBottom);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mAbsLeft);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mAbsRight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mAbsTop);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mBottom);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.mColor;
        result = 31 * result + (this.mIsSpanningTwoPages ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.mLeft);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.mOffer == null ? 0 : this.mOffer.hashCode());
        result = 31 * result + this.mPage;
        temp = Double.doubleToLongBits(this.mRight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mTop);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hotspot other = (Hotspot)obj;
        if (Double.doubleToLongBits(this.mAbsBottom) != Double.doubleToLongBits(other.mAbsBottom)) {
            return false;
        }
        if (Double.doubleToLongBits(this.mAbsLeft) != Double.doubleToLongBits(other.mAbsLeft)) {
            return false;
        }
        if (Double.doubleToLongBits(this.mAbsRight) != Double.doubleToLongBits(other.mAbsRight)) {
            return false;
        }
        if (Double.doubleToLongBits(this.mAbsTop) != Double.doubleToLongBits(other.mAbsTop)) {
            return false;
        }
        if (Double.doubleToLongBits(this.mBottom) != Double.doubleToLongBits(other.mBottom)) {
            return false;
        }
        if (this.mColor != other.mColor) {
            return false;
        }
        if (this.mIsSpanningTwoPages != other.mIsSpanningTwoPages) {
            return false;
        }
        if (Double.doubleToLongBits(this.mLeft) != Double.doubleToLongBits(other.mLeft)) {
            return false;
        }
        if (this.mOffer == null ? other.mOffer != null : !this.mOffer.equals(other.mOffer)) {
            return false;
        }
        if (this.mPage != other.mPage) {
            return false;
        }
        if (Double.doubleToLongBits(this.mRight) != Double.doubleToLongBits(other.mRight)) {
            return false;
        }
        return Double.doubleToLongBits(this.mTop) == Double.doubleToLongBits(other.mTop);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mPage);
        dest.writeParcelable((Parcelable)this.mOffer, flags);
        dest.writeByte(this.mIsSpanningTwoPages ? (byte)1 : 0);
        dest.writeDouble(this.mTop);
        dest.writeDouble(this.mBottom);
        dest.writeDouble(this.mLeft);
        dest.writeDouble(this.mRight);
        dest.writeDouble(this.mAbsTop);
        dest.writeDouble(this.mAbsBottom);
        dest.writeDouble(this.mAbsLeft);
        dest.writeDouble(this.mAbsRight);
        dest.writeInt(this.mColor);
    }
}

