/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.database.DatabaseWrapper;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.model.ShoppinglistItem;
import com.shopgun.android.sdk.model.User;
import com.shopgun.android.sdk.shoppinglists.ListManager;
import com.shopgun.android.sdk.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DbUtils {
    public static final String TAG = Constants.getTag(DbUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ContentValues> dumpTable(SQLiteDatabase db, String table) {
        db.acquireReference();
        try {
            Cursor c = db.query(table, null, null, null, null, null, null);
            List<ContentValues> list = DbUtils.cursorToContentValues(c);
            return list;
        }
        finally {
            db.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray dumpTableToJSONArray(SQLiteDatabase db, String table) {
        try {
            List<ContentValues> list = DbUtils.dumpTable(db, table);
            JSONArray jTable = new JSONArray();
            for (ContentValues cv : list) {
                try {
                    JSONObject jRow = new JSONObject();
                    for (Map.Entry e : cv.valueSet()) {
                        jRow.put((String)e.getKey(), (Object)String.valueOf(e.getValue()));
                    }
                    jTable.put((Object)jRow);
                }
                catch (JSONException e) {}
            }
            JSONArray jSONArray = jTable;
            return jSONArray;
        }
        finally {
            db.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ContentValues> cursorToContentValues(Cursor c) {
        ArrayList<ContentValues> list = new ArrayList<ContentValues>();
        try {
            if (c.moveToFirst()) {
                do {
                    ContentValues map = new ContentValues();
                    DatabaseUtils.cursorRowToContentValues((Cursor)c, (ContentValues)map);
                    list.add(map);
                } while (c.moveToNext());
            }
        }
        finally {
            DbUtils.closeCursor(c);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentValues cursorToContentValuesSingle(Cursor c) {
        try {
            ContentValues map = new ContentValues();
            if (c.moveToFirst()) {
                DatabaseUtils.cursorRowToContentValues((Cursor)c, (ContentValues)map);
            }
            ContentValues contentValues = map;
            return contentValues;
        }
        catch (IllegalStateException e) {
            ContentValues contentValues = new ContentValues();
            return contentValues;
        }
        finally {
            DbUtils.closeCursor(c);
        }
    }

    public static void closeCursor(Cursor c) {
        if (c != null && !c.isClosed()) {
            c.close();
        }
    }

    public static int migrateOfflineLists(ListManager manager, DatabaseWrapper db, boolean delete) {
        User offlineUser = new User();
        List<Shoppinglist> offlineUserLists = db.getLists(offlineUser);
        if (offlineUserLists.isEmpty()) {
            return 0;
        }
        for (Shoppinglist sl : offlineUserLists) {
            List<ShoppinglistItem> noUserItems = db.getItems(sl, offlineUser);
            if (noUserItems.isEmpty()) continue;
            Shoppinglist tmpSl = Shoppinglist.fromName(sl.getName());
            tmpSl.setType(sl.getType());
            manager.addList(tmpSl);
            for (ShoppinglistItem sli : noUserItems) {
                sli.setShoppinglistId(tmpSl.getId());
                sli.setId(Utils.createUUID());
                manager.addItem(sli);
            }
            if (!delete) continue;
            db.deleteList(sl, offlineUser);
            db.deleteItems(sl.getId(), null, offlineUser);
        }
        return offlineUserLists.size();
    }

    public static boolean intToBool(int i) {
        return i == 1;
    }

    public static int unescape(boolean b) {
        return b ? 1 : 0;
    }

    public static String unescape(Boolean b) {
        return b != null && b != false ? "1" : "0";
    }

    public static void bindOrNull(SQLiteStatement s, int index, String value) {
        if (value == null) {
            s.bindNull(index);
        } else {
            s.bindString(index, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> cursorToStrings(Cursor c, String column) {
        try {
            ArrayList<String> list = new ArrayList<String>(c.getCount());
            if (c.moveToFirst()) {
                int index = c.getColumnIndex(column);
                do {
                    list.add(c.getString(index));
                } while (c.moveToNext());
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (IllegalStateException e) {
            ArrayList<String> arrayList = new ArrayList<String>();
            return arrayList;
        }
        finally {
            DbUtils.closeCursor(c);
        }
    }
}

