/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.speech;

import android.content.Context;
import android.content.Intent;
import android.os.RemoteException;
import com.iflytek.cloud.InitListener;
import com.iflytek.cloud.SpeechUtility;
import com.iflytek.cloud.thirdparty.cb;
import com.iflytek.speech.SpeechModuleAidl;
import com.iflytek.speech.SynthesizerListener;
import com.iflytek.speech.aidl.ISpeechSynthesizer;

public class SpeechSynthesizerAidl
extends SpeechModuleAidl<ISpeechSynthesizer> {
    public SpeechSynthesizerAidl(Context context, InitListener initListener) {
        super(context, initListener, "com.iflytek.vflynote.synthesize");
    }

    public int synthesizeToUrl(String string, SynthesizerListener synthesizerListener) {
        if (this.mService == null) {
            return 21003;
        }
        if (synthesizerListener == null) {
            return 20012;
        }
        try {
            Intent intent = this.getIntent();
            intent.putExtra("text", string);
            return ((ISpeechSynthesizer)this.mService).synthesizeToUrl(intent, synthesizerListener);
        }
        catch (RemoteException remoteException) {
            cb.a(remoteException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 21004;
    }

    public int startSpeaking(String string, SynthesizerListener synthesizerListener) {
        if (this.mService == null) {
            return 21003;
        }
        if (synthesizerListener == null) {
            return 20012;
        }
        try {
            Intent intent = this.getIntent();
            intent.putExtra("text", string);
            return ((ISpeechSynthesizer)this.mService).startSpeaking(intent, synthesizerListener);
        }
        catch (RemoteException remoteException) {
            cb.a(remoteException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 21004;
    }

    public int pauseSpeaking(SynthesizerListener synthesizerListener) {
        if (this.mService == null) {
            return 21003;
        }
        if (synthesizerListener == null) {
            return 20012;
        }
        try {
            return ((ISpeechSynthesizer)this.mService).pauseSpeaking(synthesizerListener);
        }
        catch (RemoteException remoteException) {
            cb.a(remoteException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 21004;
    }

    public int resumeSpeaking(SynthesizerListener synthesizerListener) {
        if (this.mService == null) {
            return 21003;
        }
        if (synthesizerListener == null) {
            return 20012;
        }
        try {
            return ((ISpeechSynthesizer)this.mService).resumeSpeaking(synthesizerListener);
        }
        catch (RemoteException remoteException) {
            cb.a(remoteException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 21004;
    }

    public int stopSpeaking(SynthesizerListener synthesizerListener) {
        if (this.mService == null) {
            return 21003;
        }
        if (synthesizerListener == null) {
            return 20012;
        }
        try {
            return ((ISpeechSynthesizer)this.mService).stopSpeaking(synthesizerListener);
        }
        catch (RemoteException remoteException) {
            cb.a(remoteException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 21004;
    }

    public boolean isSpeaking() {
        boolean bl2 = false;
        try {
            if (this.mService != null) {
                bl2 = ((ISpeechSynthesizer)this.mService).isSpeaking();
            }
        }
        catch (RemoteException remoteException) {
            cb.a(remoteException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl2;
    }

    @Override
    public int setParameter(String string, String string2) {
        return super.setParameter(string, string2);
    }

    @Override
    public String getParameter(String string) {
        if (string.equals("local_speakers")) {
            try {
                if (SpeechUtility.getUtility() == null) {
                    return null;
                }
                int n2 = SpeechUtility.getUtility().getServiceVersion();
                if (n2 < 44 || n2 >= 10000 && n2 < 10013) {
                    return null;
                }
                return ((ISpeechSynthesizer)this.mService).getLocalSpeakerList();
            }
            catch (RemoteException remoteException) {
                cb.a(remoteException);
                return "20999";
            }
        }
        return super.getParameter(string);
    }

    @Override
    public boolean destory() {
        this.mService = null;
        return super.destory();
    }
}

