/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.push.core;

import android.app.Activity;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.Process;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.aop.push.PushAutoTrackHelper;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.util.FileUtils;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class PushProcess {
    private static final String SA_PUSH_ID = "SA_PUSH_ID";
    private static final String DIR_NAME = "sensors.push";
    private static final String TAG = "SA.NotificationProcessor";
    private static final int GT_PUSH_MSG = 1;
    private static PushProcess INSTANCE;
    private final int myPid;
    private final AtomicInteger mSAIntentId;
    private final Map<String, NotificationInfo> mGeTuiPushInfoMap;
    private final Handler mPushHandler;
    private final boolean customizeEnable;
    private final WeakHashMap<PendingIntent, String> mPendingIntent2Ids;
    private WeakReference<Intent> mLastIntentRef;
    private File mPushFile;

    private PushProcess() {
        Context context = SensorsDataAPI.sharedInstance().getSAContextManager().getContext();
        if (context != null) {
            this.mPushFile = new File(context.getFilesDir(), DIR_NAME);
        }
        this.mSAIntentId = new AtomicInteger();
        this.myPid = Process.myPid();
        this.customizeEnable = Build.VERSION.SDK_INT >= 19;
        this.mPendingIntent2Ids = new WeakHashMap();
        this.mGeTuiPushInfoMap = new HashMap<String, NotificationInfo>();
        HandlerThread thread = new HandlerThread("SA.PushThread");
        thread.start();
        this.mPushHandler = new Handler(thread.getLooper()){

            public void handleMessage(Message msg) {
                int code = msg.what;
                if (code == 1) {
                    try {
                        String msgId = (String)msg.obj;
                        if (!TextUtils.isEmpty((CharSequence)msgId) && PushProcess.this.mGeTuiPushInfoMap.containsKey(msgId)) {
                            NotificationInfo push = (NotificationInfo)PushProcess.this.mGeTuiPushInfoMap.get(msgId);
                            PushProcess.this.mGeTuiPushInfoMap.remove(msgId);
                            if (push != null) {
                                PushAutoTrackHelper.trackGeTuiNotificationClicked(push.title, push.content, null, push.time);
                            }
                        }
                    }
                    catch (Exception e) {
                        SALog.printStackTrace((Exception)e);
                    }
                }
            }
        };
    }

    public static synchronized PushProcess getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PushProcess();
        }
        return INSTANCE;
    }

    public void hookIntent(Intent intent) {
        if (this.customizeEnable) {
            try {
                if (!this.isHooked(intent)) {
                    intent.putExtra(SA_PUSH_ID, this.myPid + "-" + this.mSAIntentId.getAndIncrement());
                }
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
        }
    }

    public void hookPendingIntent(Intent intent, PendingIntent pendingIntent) {
        if (this.customizeEnable) {
            String pushId = intent.getStringExtra(SA_PUSH_ID);
            this.mPendingIntent2Ids.put(pendingIntent, pushId);
        }
    }

    public void onNotificationClick(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        try {
            WeakReference<Intent> weakReference = this.mLastIntentRef;
            if (weakReference == null || weakReference.get() != intent) {
                this.mLastIntentRef = new WeakReference<Intent>(intent);
                if (this.customizeEnable) {
                    this.trackCustomizeClick(intent);
                }
                if (context instanceof Activity) {
                    PushAutoTrackHelper.trackJPushOpenActivity(intent);
                }
                SALog.i((String)TAG, (String)"onNotificationClick");
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void onNotify(String tag, int id, final Notification notification) {
        if (this.customizeEnable) {
            try {
                if (notification.contentIntent != null) {
                    SALog.i((String)TAG, (String)("onNotify, tag: " + tag + ", id=" + id));
                    final NotificationInfo push = this.getNotificationInfo(notification);
                    if (push != null) {
                        this.mPushHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                PushProcess.this.checkAndStoreNotificationInfo(notification.contentIntent, push);
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
        }
    }

    public void trackGTClickDelayed(String messageId, String title, String content) {
        try {
            Message message = Message.obtain();
            message.what = 1;
            message.obj = messageId;
            this.mGeTuiPushInfoMap.put(messageId, new NotificationInfo(title, content, System.currentTimeMillis()));
            this.mPushHandler.sendMessageDelayed(message, 200L);
            SALog.i((String)TAG, (String)("sendMessageDelayed,msgId = " + messageId));
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void trackReceiveMessageData(String sfDate, String msgId) {
        try {
            if (this.mPushHandler.hasMessages(1) && this.mGeTuiPushInfoMap.containsKey(msgId)) {
                this.mPushHandler.removeMessages(1);
                SALog.i((String)TAG, (String)"remove GeTui Push Message");
                NotificationInfo push = this.mGeTuiPushInfoMap.get(msgId);
                if (push != null) {
                    PushAutoTrackHelper.trackGeTuiNotificationClicked(push.title, push.content, sfDate, push.time);
                }
                this.mGeTuiPushInfoMap.remove(msgId);
                SALog.i((String)TAG, (String)(" onGeTuiReceiveMessage:msg id : " + msgId));
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private boolean isHooked(Intent intent) {
        try {
            return intent.hasExtra(SA_PUSH_ID);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
            return false;
        }
    }

    private void checkAndStoreNotificationInfo(PendingIntent pendingIntent, NotificationInfo info) {
        if (pendingIntent == null) {
            SALog.i((String)TAG, (String)"pendingIntent is null");
            return;
        }
        try {
            String intentId = this.mPendingIntent2Ids.get(pendingIntent);
            if (intentId != null) {
                this.storeNotificationInfo(info, intentId);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private void storeNotificationInfo(NotificationInfo push, String intentId) {
        SALog.i((String)TAG, (String)("storeNotificationInfo: id=" + intentId + ", actionInfo" + push));
        try {
            this.initAndCleanDir();
            File toFile = new File(this.mPushFile, intentId);
            if (toFile.exists()) {
                SALog.i((String)TAG, (String)"toFile exists");
                toFile.delete();
            }
            String content = push.toJson();
            String secretContent = (String)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_encrypt", "encryptAES", new Object[]{content});
            if (TextUtils.isEmpty((CharSequence)secretContent)) {
                secretContent = content;
            }
            FileUtils.writeToFile((File)toFile, (String)secretContent);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private synchronized void initAndCleanDir() {
        try {
            File[] files;
            if (!this.mPushFile.exists()) {
                this.mPushFile.mkdirs();
            }
            if ((files = this.mPushFile.listFiles()) != null) {
                long currentTime = System.currentTimeMillis();
                for (File file : files) {
                    if (currentTime - file.lastModified() <= 86400000L) continue;
                    SALog.i((String)TAG, (String)("clean file: " + file));
                    file.delete();
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private NotificationInfo getNotificationInfo(Notification notification) {
        NotificationInfo push = null;
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                String title = notification.extras.getString("android.title");
                String content = notification.extras.getString("android.text");
                push = new NotificationInfo(title, content, 0L);
                SALog.i((String)TAG, (String)("NotificationInfo: title = " + title + "content = " + content));
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
        }
        return push;
    }

    private NotificationInfo getNotificationInfo(String id) {
        try {
            this.initAndCleanDir();
            File inFile = new File(this.mPushFile, id);
            if (!inFile.exists()) {
                return null;
            }
            String json = FileUtils.readFileToString((File)inFile);
            if (TextUtils.isEmpty((CharSequence)json)) {
                return null;
            }
            String decryptJson = (String)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_encrypt", "decryptAES", new Object[]{json});
            if (TextUtils.isEmpty((CharSequence)decryptJson)) {
                decryptJson = json;
            }
            SALog.i((String)TAG, (String)("cache local notification info:" + decryptJson));
            NotificationInfo notificationInfo = NotificationInfo.fromJson(decryptJson);
            return notificationInfo == null ? NotificationInfo.fromJson(json) : notificationInfo;
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
            return null;
        }
    }

    private void trackCustomizeClick(Intent intent) {
        if (!this.customizeEnable) {
            return;
        }
        try {
            if (this.isHooked(intent)) {
                final String id = intent.getStringExtra(SA_PUSH_ID);
                intent.removeExtra(SA_PUSH_ID);
                if (TextUtils.isEmpty((CharSequence)id)) {
                    SALog.i((String)TAG, (String)"intent tag is null");
                    return;
                }
                this.mPushHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationInfo push = PushProcess.this.getNotificationInfo(id);
                        if (push != null) {
                            PushAutoTrackHelper.trackNotificationOpenedEvent(null, push.title, push.content, "Local", null);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    static class NotificationInfo {
        String title;
        String content;
        long time;

        NotificationInfo(String title, String content, long time) {
            this.title = title;
            this.content = content;
            this.time = time;
        }

        public static NotificationInfo fromJson(String json) {
            try {
                JSONObject jsonObject = new JSONObject(json);
                return new NotificationInfo(jsonObject.optString("title"), jsonObject.optString("content"), jsonObject.optLong("time"));
            }
            catch (JSONException e) {
                SALog.printStackTrace((Exception)((Object)e));
                return null;
            }
        }

        public String toString() {
            return "NotificationInfo{title='" + this.title + '\'' + ", content='" + this.content + '\'' + ", time=" + this.time + '}';
        }

        public String toJson() {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("title", (Object)this.title);
                jsonObject.put("content", (Object)this.content);
                jsonObject.put("time", this.time);
                return jsonObject.toString();
            }
            catch (JSONException e) {
                SALog.printStackTrace((Exception)((Object)e));
                return null;
            }
        }
    }
}

