/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.exposure;

import android.graphics.Rect;
import android.text.TextUtils;
import android.view.View;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.business.exposure.SAExposureConfig;
import com.sensorsdata.analytics.android.sdk.core.business.exposure.SAExposureData;
import com.sensorsdata.analytics.android.sdk.exposure.ExposureView;
import com.sensorsdata.analytics.android.sdk.exposure.ExposureVisible;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class ExposedPage {
    private final WeakHashMap<View, ExposureView> mViewWeakHashMap = new WeakHashMap();
    private final Map<String, ExposureView> mExposureViewMap = new HashMap<String, ExposureView>();
    private final ExposureVisible mExposureVisible = new ExposureVisible();
    private static final String TAG = "SA.ExposedPage";

    public int getExposureViewSize() {
        return this.mViewWeakHashMap.size();
    }

    public synchronized void addExposureView(View view, ExposureView exposureView) {
        if (view == null || exposureView == null) {
            return;
        }
        this.mViewWeakHashMap.put(view, exposureView);
    }

    public synchronized void addExposureView(String identifier, ExposureView exposureView) {
        if (TextUtils.isEmpty((CharSequence)identifier) || exposureView == null) {
            return;
        }
        this.mExposureViewMap.put(identifier, exposureView);
    }

    public synchronized void removeExposureView(View view, String identifier) {
        if (view == null) {
            return;
        }
        ExposureView exposureView = this.getExposureView(view);
        if (exposureView != null && exposureView.getExposureData() != null) {
            if (exposureView.getExposureData().getIdentifier() != null && identifier != null) {
                if (exposureView.getExposureData().getIdentifier().equals(identifier)) {
                    this.mViewWeakHashMap.remove(view);
                    this.mExposureViewMap.remove(identifier);
                }
            } else if (exposureView.getExposureData().getIdentifier() == null && identifier == null) {
                this.mViewWeakHashMap.remove(view);
            }
        }
    }

    public Collection<ExposureView> getExposureViews() {
        return this.mViewWeakHashMap.values();
    }

    public synchronized ExposureView getExposureView(View view) {
        if (view == null) {
            return null;
        }
        return this.mViewWeakHashMap.get(view);
    }

    public synchronized ExposureView getExposureView(String identifier) {
        if (TextUtils.isEmpty((CharSequence)identifier)) {
            return null;
        }
        return this.mExposureViewMap.get(identifier);
    }

    public synchronized void invisibleElement() {
        for (View view : this.mViewWeakHashMap.keySet()) {
            ExposureView exposureView;
            if (view == null || (exposureView = this.mViewWeakHashMap.get(view)) == null) continue;
            exposureView.setLastVisible(false);
        }
    }

    public synchronized List<ExposureView> getExposureViewList(View mView) {
        this.mExposureVisible.cleanVisible();
        ArrayList<ExposureView> exposureViewList = new ArrayList<ExposureView>();
        if (mView != null) {
            ExposureView exposureView = this.mViewWeakHashMap.get(mView);
            exposureViewList.add(exposureView);
        } else {
            for (View view : this.mViewWeakHashMap.keySet()) {
                if (view == null) continue;
                ExposureView exposureView = this.mViewWeakHashMap.get(view);
                SALog.i((String)TAG, (String)("getExposureViewList->exposureview:" + exposureView));
                if (!this.viewIsExposed(exposureView)) continue;
                exposureViewList.add(exposureView);
            }
            this.mExposureVisible.cleanVisible();
            Collections.sort(exposureViewList, new Comparator<ExposureView>(){

                @Override
                public int compare(ExposureView o1, ExposureView o2) {
                    return (int)(o1.getAddTime() - o2.getAddTime());
                }
            });
        }
        return exposureViewList;
    }

    private boolean viewIsExposed(ExposureView exposureView) {
        if (exposureView == null) {
            return false;
        }
        SAExposureData exposureData = exposureView.getExposureData();
        if (exposureData == null) {
            return false;
        }
        SAExposureConfig exposureConfig = exposureData.getExposureConfig();
        if (exposureConfig == null || !exposureView.isAddExposureView()) {
            return false;
        }
        boolean repeated = exposureConfig.isRepeated();
        boolean isExposed = this.isExposed(exposureView);
        SALog.i((String)TAG, (String)("viewIsExposed:" + isExposed));
        return repeated ? isExposed : isExposed && (!exposureView.isExposed() || exposureView.isActivityChange());
    }

    private boolean isExposed(ExposureView exposureView) {
        boolean isLastVisible = exposureView.isLastVisible();
        View view = exposureView.getView();
        if (view == null) {
            return false;
        }
        Rect rect = new Rect();
        if (!this.mExposureVisible.isVisible(view, rect)) {
            exposureView.setLastVisible(false);
            return false;
        }
        if (isLastVisible) {
            return false;
        }
        float areaRate = exposureView.getExposureData().getExposureConfig().getAreaRate();
        return this.visibleRect(view, rect, areaRate);
    }

    private boolean visibleRect(View view, Rect rect, float areaRate) {
        if (view != null) {
            SALog.i((String)TAG, (String)("width = " + rect.width() + ", height = " + rect.height() + ", MeasuredHeight = " + view.getMeasuredHeight() + ", MeasuredWidth = " + view.getMeasuredWidth()));
            return (float)(rect.width() * rect.height()) >= (float)(view.getMeasuredHeight() * view.getMeasuredWidth()) * areaRate;
        }
        return false;
    }
}

