/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.encrypt.encryptor;

import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.encrypt.AESSecretManager;
import com.sensorsdata.analytics.android.sdk.encrypt.encryptor.SymmetricEncryptMode;
import com.sensorsdata.analytics.android.sdk.encrypt.impl.AbsSAEncrypt;
import com.sensorsdata.analytics.android.sdk.encrypt.utils.EncryptUtils;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;

public class SAECEncrypt
extends AbsSAEncrypt {
    byte[] aesKey;
    String mEncryptKey;

    public String symmetricEncryptType() {
        return "AES";
    }

    public String encryptEvent(byte[] event) {
        return EncryptUtils.symmetricEncrypt(this.aesKey, event, SymmetricEncryptMode.AES);
    }

    public String asymmetricEncryptType() {
        return "EC";
    }

    public String encryptSymmetricKeyWithPublicKey(String publicKey) {
        if (this.mEncryptKey == null) {
            try {
                this.aesKey = EncryptUtils.generateSymmetricKey(SymmetricEncryptMode.AES);
                this.mEncryptKey = EncryptUtils.encryptAESKey(publicKey, this.aesKey, "EC");
            }
            catch (NoSuchAlgorithmException e) {
                SALog.printStackTrace((Exception)e);
                return null;
            }
        }
        return this.mEncryptKey;
    }

    @Override
    public String encryptEventRecord(String eventJson) {
        return AESSecretManager.getInstance().encryptAES(eventJson);
    }

    @Override
    public String decryptEventRecord(String encryptEvent) {
        return AESSecretManager.getInstance().decryptAES(encryptEvent);
    }

    static {
        try {
            Class<?> provider = Class.forName("org.spongycastle.jce.provider.BouncyCastleProvider");
            Security.addProvider((Provider)provider.newInstance());
        }
        catch (Exception e) {
            SALog.i((String)"SA.SAECEncrypt", (String)e.toString());
        }
    }
}

