/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.encrypt.biz;

import android.content.Context;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SAConfigOptions;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.encrypt.IPersistentSecretKey;
import com.sensorsdata.analytics.android.sdk.encrypt.R;
import com.sensorsdata.analytics.android.sdk.encrypt.SAEncryptListener;
import com.sensorsdata.analytics.android.sdk.encrypt.SecreteKey;
import com.sensorsdata.analytics.android.sdk.encrypt.encryptor.SAECEncrypt;
import com.sensorsdata.analytics.android.sdk.encrypt.encryptor.SARSAEncrypt;
import com.sensorsdata.analytics.android.sdk.encrypt.utils.EncryptUtils;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.SAStoreManager;
import com.sensorsdata.analytics.android.sdk.util.SADisplayUtil;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class SecretKeyManager {
    private static final String TAG = "SA.SecretKeyManager";
    private static final String SP_SECRET_KEY = "secret_key";
    private static final String SP_SUPPORT_TRANSPORT_ENCRYPT = "supportTransportEncrypt";
    private static final int KEY_VERSION_DEFAULT = 0;
    private final IPersistentSecretKey mPersistentSecretKey;
    private final SAConfigOptions mSAConfigOptions;
    private final List<SAEncryptListener> mListeners;
    private static SecretKeyManager INSTANCE;

    private SecretKeyManager(SAContextManager contextManager) {
        this.mSAConfigOptions = contextManager.getInternalConfigs().saConfigOptions;
        this.mPersistentSecretKey = contextManager.getInternalConfigs().saConfigOptions.getPersistentSecretKey();
        this.mListeners = contextManager.getInternalConfigs().saConfigOptions.getEncryptors();
        this.mListeners.add(new SARSAEncrypt());
        if (EncryptUtils.isECEncrypt()) {
            this.mListeners.add(new SAECEncrypt());
        }
    }

    public static SecretKeyManager getInstance(SAContextManager contextManager) {
        if (INSTANCE == null) {
            INSTANCE = new SecretKeyManager(contextManager);
        }
        return INSTANCE;
    }

    public void storeSecretKey(String configJSON) {
        try {
            JSONObject configObject = new JSONObject(configJSON);
            if (this.mSAConfigOptions.isEnableEncrypt() || this.mSAConfigOptions.isTransportEncrypt()) {
                String configs = configObject.optString("configs");
                configObject = new JSONObject(configs);
                SecreteKey secreteKey = new SecreteKey("", -1, "", "");
                List encryptListeners = this.mSAConfigOptions.getEncryptors();
                if (encryptListeners != null && !encryptListeners.isEmpty()) {
                    String[] types;
                    JSONObject keyObject = configObject.optJSONObject("key_v2");
                    if (keyObject != null && (types = keyObject.optString("type").split("\\+")).length == 2) {
                        String asymmetricType = types[0];
                        String symmetricType = types[1];
                        for (SAEncryptListener encryptListener : encryptListeners) {
                            if (!asymmetricType.equals(encryptListener.asymmetricEncryptType()) || !symmetricType.equals(encryptListener.symmetricEncryptType())) continue;
                            secreteKey.key = keyObject.optString("public_key");
                            secreteKey.version = keyObject.optInt("pkv");
                            secreteKey.asymmetricEncryptType = asymmetricType;
                            secreteKey.symmetricEncryptType = symmetricType;
                        }
                    }
                    if (TextUtils.isEmpty((CharSequence)secreteKey.key)) {
                        this.parseSecreteKey(configObject.optJSONObject("key"), secreteKey);
                    }
                }
                this.storeSecretKey(secreteKey);
            }
            if (configObject.has(SP_SUPPORT_TRANSPORT_ENCRYPT)) {
                SAStoreManager.getInstance().setBool(SP_SUPPORT_TRANSPORT_ENCRYPT, configObject.optBoolean(SP_SUPPORT_TRANSPORT_ENCRYPT));
            } else {
                SAStoreManager.getInstance().setBool(SP_SUPPORT_TRANSPORT_ENCRYPT, false);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public SecreteKey loadSecretKey() throws JSONException {
        if (this.mPersistentSecretKey != null) {
            return this.readAppKey();
        }
        return this.readLocalKey();
    }

    public SAEncryptListener getEncryptListener(SecreteKey secreteKey) {
        if (!this.isSecretKeyNull(secreteKey)) {
            for (SAEncryptListener listener : this.mListeners) {
                if (!this.isMatchEncryptType(listener, secreteKey)) continue;
                return listener;
            }
        }
        return null;
    }

    public boolean isSecretKeyNull(SecreteKey secreteKey) {
        return secreteKey == null || TextUtils.isEmpty((CharSequence)secreteKey.key) || secreteKey.version == 0;
    }

    public String checkPublicSecretKey(Context activity, String version, String key, String symmetricEncryptType, String asymmetricEncryptType) {
        try {
            SecreteKey secreteKey = this.loadSecretKey();
            if (secreteKey == null || TextUtils.isEmpty((CharSequence)secreteKey.key)) {
                return SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_encrypt_key_null);
            }
            if (version.equals(secreteKey.version + "") && this.disposeECPublicKey(key).equals(this.disposeECPublicKey(secreteKey.key))) {
                if (symmetricEncryptType == null || asymmetricEncryptType == null || symmetricEncryptType.equals(secreteKey.symmetricEncryptType) && asymmetricEncryptType.equals(secreteKey.asymmetricEncryptType)) {
                    return SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_encrypt_pass);
                }
                return String.format(SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_encrypt_verify_fail_type), symmetricEncryptType, asymmetricEncryptType, secreteKey.symmetricEncryptType, secreteKey.asymmetricEncryptType);
            }
            return String.format(SADisplayUtil.getStringResource((Context)activity, (int)R.string.sensors_analytics_encrypt_verify_fail_version), version, secreteKey.version);
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
            return "";
        }
    }

    public Boolean isSupportTransportEncrypt() {
        return SAStoreManager.getInstance().isExists(SP_SUPPORT_TRANSPORT_ENCRYPT) ? Boolean.valueOf(SAStoreManager.getInstance().getBool(SP_SUPPORT_TRANSPORT_ENCRYPT, false)) : null;
    }

    private String disposeECPublicKey(String key) {
        if (TextUtils.isEmpty((CharSequence)key) || !key.startsWith("EC:")) {
            return key;
        }
        return key.substring(key.indexOf(":") + 1);
    }

    private SecreteKey readAppKey() {
        String publicKey = "";
        int keyVersion = 0;
        String symmetricEncryptType = "";
        String asymmetricEncryptType = "";
        SecreteKey rsaPublicKeyVersion = this.mPersistentSecretKey.loadSecretKey();
        if (rsaPublicKeyVersion != null) {
            publicKey = rsaPublicKeyVersion.key;
            keyVersion = rsaPublicKeyVersion.version;
            symmetricEncryptType = rsaPublicKeyVersion.symmetricEncryptType;
            asymmetricEncryptType = rsaPublicKeyVersion.asymmetricEncryptType;
        }
        SALog.i((String)TAG, (String)("readAppKey [key = " + publicKey + " ,v = " + keyVersion + " ,symmetricEncryptType = " + symmetricEncryptType + " ,asymmetricEncryptType = " + asymmetricEncryptType + "]"));
        return new SecreteKey(publicKey, keyVersion, symmetricEncryptType, asymmetricEncryptType);
    }

    private SecreteKey readLocalKey() throws JSONException {
        String publicKey = "";
        int keyVersion = 0;
        String symmetricEncryptType = "";
        String asymmetricEncryptType = "";
        String secretKey = SAStoreManager.getInstance().getString(SP_SECRET_KEY, "");
        if (!TextUtils.isEmpty((CharSequence)secretKey)) {
            JSONObject jsonObject = new JSONObject(secretKey);
            publicKey = jsonObject.optString("key", "");
            keyVersion = jsonObject.optInt("version", 0);
            symmetricEncryptType = jsonObject.optString("symmetricEncryptType", "");
            asymmetricEncryptType = jsonObject.optString("asymmetricEncryptType", "");
        }
        SALog.i((String)TAG, (String)("readLocalKey [key = " + publicKey + " ,v = " + keyVersion + " ,symmetricEncryptType = " + symmetricEncryptType + " ,asymmetricEncryptType = " + asymmetricEncryptType + "]"));
        return new SecreteKey(publicKey, keyVersion, symmetricEncryptType, asymmetricEncryptType);
    }

    private boolean isMatchEncryptType(SAEncryptListener listener, SecreteKey secreteKey) {
        return listener != null && !this.isSecretKeyNull(secreteKey) && !this.isEncryptorTypeNull(listener) && listener.asymmetricEncryptType().equals(secreteKey.asymmetricEncryptType) && listener.symmetricEncryptType().equals(secreteKey.symmetricEncryptType);
    }

    private boolean isEncryptorTypeNull(SAEncryptListener saEncryptListener) {
        return TextUtils.isEmpty((CharSequence)saEncryptListener.asymmetricEncryptType()) || TextUtils.isEmpty((CharSequence)saEncryptListener.symmetricEncryptType());
    }

    private void parseSecreteKey(JSONObject keyObject, SecreteKey secreteKey) {
        if (keyObject != null) {
            try {
                String key_ec;
                if (keyObject.has("key_ec") && EncryptUtils.isECEncrypt() && !TextUtils.isEmpty((CharSequence)(key_ec = keyObject.optString("key_ec")))) {
                    keyObject = new JSONObject(key_ec);
                }
                secreteKey.key = keyObject.optString("public_key");
                secreteKey.symmetricEncryptType = "AES";
                if (keyObject.has("type")) {
                    String type = keyObject.optString("type");
                    secreteKey.key = type + ":" + secreteKey.key;
                    secreteKey.asymmetricEncryptType = type;
                } else {
                    secreteKey.asymmetricEncryptType = "RSA";
                }
                secreteKey.version = keyObject.optInt("pkv");
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
        }
    }

    private void storeSecretKey(SecreteKey secreteKey) {
        try {
            SALog.i((String)TAG, (String)("[saveSecretKey] publicKey = " + secreteKey.toString()));
            SAEncryptListener encryptListener = this.getEncryptListener(secreteKey);
            if (encryptListener != null) {
                if (this.mPersistentSecretKey != null) {
                    this.mPersistentSecretKey.saveSecretKey(secreteKey);
                    SAStoreManager.getInstance().setString(SP_SECRET_KEY, "");
                } else {
                    SAStoreManager.getInstance().setString(SP_SECRET_KEY, secreteKey.toString());
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }
}

