/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.autotrack.utils;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.TabHost;
import com.sensorsdata.analytics.android.autotrack.core.beans.ViewContext;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.util.ReflectUtil;
import com.sensorsdata.analytics.android.sdk.util.SAFragmentUtils;
import com.sensorsdata.analytics.android.sdk.util.SAViewUtils;
import com.sensorsdata.analytics.android.sdk.util.WindowHelper;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.List;

public class AutoTrackViewUtils {
    public static ViewContext getTabLayoutContext(Object objectTab, View tabLayoutView) {
        try {
            Object fragment = null;
            Activity activity = null;
            if (objectTab instanceof Context) {
                activity = SAViewUtils.getActivityOfView((Context)((Context)objectTab), null);
            } else {
                Field[] fields;
                for (Field field : fields = objectTab.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    Object bridgeObject = field.get(objectTab);
                    if (bridgeObject instanceof Activity) {
                        activity = (Activity)bridgeObject;
                        break;
                    }
                    if (SAFragmentUtils.isFragment((Object)bridgeObject)) {
                        fragment = bridgeObject;
                        break;
                    }
                    if (!(bridgeObject instanceof View)) continue;
                    View view = (View)bridgeObject;
                    activity = SAViewUtils.getActivityOfView((Context)view.getContext(), null);
                    break;
                }
            }
            if (tabLayoutView != null) {
                if (activity == null) {
                    activity = SAViewUtils.getActivityOfView((Context)tabLayoutView.getContext(), null);
                }
                if (fragment == null) {
                    fragment = SAFragmentUtils.getFragmentFromView((View)tabLayoutView, (Activity)activity);
                }
            }
            if (activity == null && fragment != null) {
                activity = SAFragmentUtils.getActivityFromFragment(fragment);
            }
            return new ViewContext(activity, fragment, tabLayoutView);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
            return null;
        }
    }

    public static View getTabView(String tabName) {
        View view = WindowHelper.getClickView((String)tabName);
        if (view != null) {
            View currentView = view;
            View tabHostView = null;
            while (null == tabHostView && null != currentView && null != currentView.getParent()) {
                if (!((currentView = (View)currentView.getParent()) instanceof TabHost)) continue;
                tabHostView = currentView;
            }
            if (null != tabHostView && SAViewUtils.isViewIgnored(tabHostView)) {
                return null;
            }
        }
        return view;
    }

    public static String getTabLayoutText(View view, Object tab) {
        Object obj_text;
        String viewText = null;
        try {
            if (view != null) {
                if (view instanceof ViewGroup) {
                    StringBuilder stringBuilder = new StringBuilder();
                    viewText = SAViewUtils.traverseView((StringBuilder)stringBuilder, (ViewGroup)((ViewGroup)view));
                    if (!TextUtils.isEmpty((CharSequence)viewText)) {
                        viewText = viewText.substring(0, viewText.length() - 1);
                    }
                } else {
                    viewText = SAViewUtils.getViewContent((View)view);
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        if (TextUtils.isEmpty(viewText) && (obj_text = ReflectUtil.callMethod((Object)tab, (String)"getText", (Object[])new Object[0])) != null) {
            viewText = obj_text.toString();
        }
        return viewText;
    }

    public static View getTabLayout(Object tab) {
        View view = AutoTrackViewUtils.getAndroidXTabLayout(tab);
        if (view == null) {
            view = AutoTrackViewUtils.getSupportTabLayout(tab);
        }
        return view;
    }

    public static boolean isBindViewPager(View tabLayout) {
        if (tabLayout == null) {
            return false;
        }
        View viewPager = (View)ReflectUtil.findField(tabLayout.getClass(), (Object)tabLayout, (String[])new String[]{"viewPager"});
        if (viewPager != null) {
            return true;
        }
        View tempView = AutoTrackViewUtils.findTabLayout(tabLayout);
        return tabLayout == tempView;
    }

    private static View getSupportTabLayout(Object tab) {
        View view = null;
        try {
            Class<?> supportTabLayoutCLass = Class.forName("android.support.design.widget.TabLayout");
            if (SAViewUtils.isViewIgnored(supportTabLayoutCLass)) {
                return null;
            }
            if (ReflectUtil.isInstance((Object)tab, (String[])new String[]{"android.support.design.widget.TabLayout$Tab"}) && null != (view = (View)ReflectUtil.findField((String[])new String[]{"android.support.design.widget.TabLayout$Tab"}, (Object)tab, (String[])new String[]{"mParent", "parent"})) && ReflectUtil.isInstance((Object)view, (String[])new String[]{"android.support.design.widget.TabLayout"}) && SAViewUtils.isViewIgnored((View)view)) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return view;
    }

    private static View getAndroidXTabLayout(Object tab) {
        View view = null;
        try {
            Class<?> androidXTabLayoutCLass = Class.forName("com.google.android.material.tabs.TabLayout");
            if (SAViewUtils.isViewIgnored(androidXTabLayoutCLass)) {
                return null;
            }
            if (ReflectUtil.isInstance((Object)tab, (String[])new String[]{"com.google.android.material.tabs.TabLayout$Tab"}) && null != (view = (View)ReflectUtil.findField((String[])new String[]{"com.google.android.material.tabs.TabLayout$Tab"}, (Object)tab, (String[])new String[]{"parent"})) && ReflectUtil.isInstance((Object)view, (String[])new String[]{"com.google.android.material.tabs.TabLayout"}) && SAViewUtils.isViewIgnored((View)view)) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return view;
    }

    private static View findTabLayout(View view) {
        ViewParent parentView = view.getParent();
        if (parentView instanceof ViewGroup) {
            for (int count = 0; count < ((ViewGroup)parentView).getChildCount(); ++count) {
                View v = ((ViewGroup)parentView).getChildAt(count);
                if (!"ViewPager".equals(v.getClass().getSimpleName())) continue;
                View tempTabLayout = AutoTrackViewUtils.findTabLayoutView(v);
                if (tempTabLayout == null) break;
                return tempTabLayout;
            }
        }
        if (parentView.getParent() == null) {
            return null;
        }
        return AutoTrackViewUtils.findTabLayout((View)parentView);
    }

    private static View findTabLayoutView(View view) {
        List pageChangeListeners = (List)ReflectUtil.findField(view.getClass(), (Object)view, (String[])new String[]{"mOnPageChangeListeners"});
        if (pageChangeListeners != null && pageChangeListeners.size() > 0) {
            for (Object listener : pageChangeListeners) {
                WeakReference weakReference = (WeakReference)ReflectUtil.findField(listener.getClass(), listener, (String[])new String[]{"tabLayoutRef"});
                if (weakReference == null || weakReference.get() == null) continue;
                return (View)weakReference.get();
            }
        }
        return null;
    }
}

