/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.plugin.version;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sensorsdata.analytics.android.plugin.utils.TextUtil;
import com.sensorsdata.analytics.android.plugin.version.SensorsDataSDKVersionBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u0005H\u0002J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/sensorsdata/analytics/android/plugin/version/SensorsDataSDKVersionHelper;", "", "()V", "mCurrentVersionMap", "", "", "mDependentVersionMap", "Ljava/util/ArrayList;", "Lcom/sensorsdata/analytics/android/plugin/version/SensorsDataSDKVersionBean;", "Lkotlin/collections/ArrayList;", "checkSensorsSDKVersionOnAnalytic", "getMessageBySDKCurrentVersion", "classname", "currentVersion", "getMessageBySDKRelyVersion", "relatedVersion", "Companion", "sa-gradle-plugin"})
public final class SensorsDataSDKVersionHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, ArrayList<SensorsDataSDKVersionBean>> mDependentVersionMap = new HashMap();
    @NotNull
    private final Map<String, String> mCurrentVersionMap = new HashMap();
    @NotNull
    public static final String VERSION_KEY_SENSORDATA_VERSION_CONFIG = "SensorsDataVersionConfig";
    @NotNull
    public static final String VERSION_KEY_CURRENT_VERSION = "SDK_VERSION";
    @NotNull
    public static final String VERSION_KEY_DEPENDENT_SDK_VERSION = "DEPENDENT_SDK_VERSIONS";
    @NotNull
    public static final String VERSION_KEY_PLUGIN_SDK_PATH = "com/sensorsdata/analytics/android/plugin";
    @NotNull
    public static final String DEFAULT_MESSAGE = "\u5f53\u524d\u795e\u7b56 Android SDK \u7248\u672c %s \u8fc7\u4f4e\uff0c\u8bf7\u5347\u7ea7\u81f3 %s \u53ca\u5176\u4ee5\u4e0a\u7248\u672c\u540e\u8fdb\u884c\u4f7f\u7528";

    public SensorsDataSDKVersionHelper() {
        this.mCurrentVersionMap.put(VERSION_KEY_PLUGIN_SDK_PATH, "4.0.3");
    }

    @NotNull
    public final String getMessageBySDKRelyVersion(@NotNull String classname, @Nullable String relatedVersion) {
        JsonArray jsonArray;
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter((Object)classname, (String)"classname");
        if (!TextUtil.INSTANCE.isEmpty(classname) && !TextUtil.INSTANCE.isEmpty(relatedVersion) && (jsonElement = JsonParser.parseString((String)relatedVersion)) != null && jsonElement.isJsonArray() && (jsonArray = jsonElement.getAsJsonArray()) != null && jsonArray.size() > 0) {
            ArrayList<SensorsDataSDKVersionBean> sensorSDKBeanList = new ArrayList<SensorsDataSDKVersionBean>();
            int n = jsonArray.size();
            for (int i = 0; i < n; ++i) {
                JsonObject jsonObjectSon;
                SensorsDataSDKVersionBean sensorSDKBean;
                JsonElement jsonElementSon = jsonArray.get(i);
                if (!jsonElementSon.isJsonObject() || (sensorSDKBean = SensorsDataSDKVersionBean.Companion.createSensorDataSDKBean(jsonObjectSon = jsonElementSon.getAsJsonObject())) == null) continue;
                sensorSDKBeanList.add(sensorSDKBean);
            }
            if (sensorSDKBeanList.size() > 0) {
                this.mDependentVersionMap.put(classname, sensorSDKBeanList);
            }
        }
        return !this.mCurrentVersionMap.isEmpty() ? this.checkSensorsSDKVersionOnAnalytic() : "";
    }

    @NotNull
    public final String getMessageBySDKCurrentVersion(@NotNull String classname, @NotNull String currentVersion) {
        Intrinsics.checkNotNullParameter((Object)classname, (String)"classname");
        Intrinsics.checkNotNullParameter((Object)currentVersion, (String)"currentVersion");
        this.mCurrentVersionMap.put(classname, currentVersion);
        return !this.mDependentVersionMap.isEmpty() ? this.checkSensorsSDKVersionOnAnalytic() : "";
    }

    private final String checkSensorsSDKVersionOnAnalytic() {
        for (ArrayList<SensorsDataSDKVersionBean> beanList : this.mDependentVersionMap.values()) {
            Iterator<SensorsDataSDKVersionBean> itList;
            if (beanList.size() <= 0) continue;
            Intrinsics.checkNotNullExpressionValue(beanList.iterator(), (String)"beanList.iterator()");
            while (itList.hasNext()) {
                SensorsDataSDKVersionBean sensorSDKBean;
                Intrinsics.checkNotNullExpressionValue((Object)itList.next(), (String)"itList.next()");
                if (!this.mCurrentVersionMap.containsKey(sensorSDKBean.getSensorsDataSDKPath())) continue;
                String string = this.mCurrentVersionMap.get(sensorSDKBean.getSensorsDataSDKPath());
                Intrinsics.checkNotNull((Object)string);
                String message = sensorSDKBean.getSensorsDataSDKVersionMessage(string);
                itList.remove();
                if (TextUtil.INSTANCE.isEmpty(message)) continue;
                return message;
            }
        }
        return "";
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/sensorsdata/analytics/android/plugin/version/SensorsDataSDKVersionHelper$Companion;", "", "()V", "DEFAULT_MESSAGE", "", "VERSION_KEY_CURRENT_VERSION", "VERSION_KEY_DEPENDENT_SDK_VERSION", "VERSION_KEY_PLUGIN_SDK_PATH", "VERSION_KEY_SENSORDATA_VERSION_CONFIG", "sa-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

