/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.plugin.manager;

import com.sensorsdata.analytics.android.gradle.AGPVersion;
import com.sensorsdata.analytics.android.plugin.configs.SAConfigHookHelper;
import com.sensorsdata.analytics.android.plugin.extension.SAExtension;
import com.sensorsdata.analytics.android.plugin.manager.SAModule;
import com.sensorsdata.analytics.android.plugin.manager.SAPackageManager;
import com.sensorsdata.analytics.android.plugin.manager.SAPluginManager;
import com.sensorsdata.analytics.android.plugin.utils.Logger;
import com.sensorsdata.analytics.android.plugin.version.SensorsDataSDKVersionHelper;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020&H\u0002J\u0006\u0010(\u001a\u00020)J\r\u0010*\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b+J\u000e\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020!J\b\u0010.\u001a\u00020&H\u0002J\b\u0010/\u001a\u00020&H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u001b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0019\u001a\u0004\b\u001c\u0010\u001dR!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0019\u001a\u0004\b\"\u0010#\u00a8\u00060"}, d2={"Lcom/sensorsdata/analytics/android/plugin/manager/SAPluginManager;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "asmVersion", "", "extension", "Lcom/sensorsdata/analytics/android/plugin/extension/SAExtension;", "getExtension", "()Lcom/sensorsdata/analytics/android/plugin/extension/SAExtension;", "setExtension", "(Lcom/sensorsdata/analytics/android/plugin/extension/SAExtension;)V", "isAndroidTV", "", "()Z", "setAndroidTV", "(Z)V", "isHookOnMethodEnter", "setHookOnMethodEnter", "packageManager", "Lcom/sensorsdata/analytics/android/plugin/manager/SAPackageManager;", "getPackageManager", "()Lcom/sensorsdata/analytics/android/plugin/manager/SAPackageManager;", "packageManager$delegate", "Lkotlin/Lazy;", "sdkVersionHelper", "Lcom/sensorsdata/analytics/android/plugin/version/SensorsDataSDKVersionHelper;", "getSdkVersionHelper", "()Lcom/sensorsdata/analytics/android/plugin/version/SensorsDataSDKVersionHelper;", "sdkVersionHelper$delegate", "supportedModules", "", "Lcom/sensorsdata/analytics/android/plugin/manager/SAModule;", "getSupportedModules", "()Ljava/util/Set;", "supportedModules$delegate", "checkDependency", "", "createExtension", "getASMVersion", "", "getASMVersionStr", "getASMVersionStr$sa_gradle_plugin", "isModuleEnable", "module", "otherInit", "parseProperty", "sa-gradle-plugin"})
public final class SAPluginManager {
    @NotNull
    private final Project project;
    public SAExtension extension;
    private boolean isHookOnMethodEnter;
    private boolean isAndroidTV;
    @NotNull
    private String asmVersion;
    @NotNull
    private final Lazy packageManager$delegate;
    @NotNull
    private final Lazy supportedModules$delegate;
    @NotNull
    private final Lazy sdkVersionHelper$delegate;

    public SAPluginManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.asmVersion = "ASM7";
        this.packageManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SAPackageManager>(this){
            final /* synthetic */ SAPluginManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SAPackageManager invoke() {
                SAPackageManager sAPackageManager = new SAPackageManager();
                SAPluginManager sAPluginManager = this.this$0;
                SAPackageManager $this$invoke_u24lambda_u240 = sAPackageManager;
                boolean bl = false;
                $this$invoke_u24lambda_u240.getExclude().addAll((Collection<String>)sAPluginManager.getExtension().getExclude());
                $this$invoke_u24lambda_u240.getInclude().addAll((Collection<String>)sAPluginManager.getExtension().getInclude());
                return sAPackageManager;
            }
        }));
        this.supportedModules$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<SAModule>>(this){
            final /* synthetic */ SAPluginManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<SAModule> invoke() {
                Set set = new LinkedHashSet<E>();
                Iterable $this$forEach$iv = this.this$0.getExtension().getDisableModules();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    String string = it;
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = string.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
                    set.add(SAModule.valueOf(string2));
                }
                return set;
            }
        }));
        this.createExtension();
        this.parseProperty();
        this.checkDependency();
        this.otherInit();
        this.sdkVersionHelper$delegate = LazyKt.lazy((Function0)sdkVersionHelper.2.INSTANCE);
    }

    @NotNull
    public final SAExtension getExtension() {
        SAExtension sAExtension = this.extension;
        if (sAExtension != null) {
            return sAExtension;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"extension");
        return null;
    }

    public final void setExtension(@NotNull SAExtension sAExtension) {
        Intrinsics.checkNotNullParameter((Object)sAExtension, (String)"<set-?>");
        this.extension = sAExtension;
    }

    public final boolean isHookOnMethodEnter() {
        return this.isHookOnMethodEnter;
    }

    public final void setHookOnMethodEnter(boolean bl) {
        this.isHookOnMethodEnter = bl;
    }

    public final boolean isAndroidTV() {
        return this.isAndroidTV;
    }

    public final void setAndroidTV(boolean bl) {
        this.isAndroidTV = bl;
    }

    @NotNull
    public final SAPackageManager getPackageManager() {
        Lazy lazy = this.packageManager$delegate;
        return (SAPackageManager)lazy.getValue();
    }

    private final Set<SAModule> getSupportedModules() {
        Lazy lazy = this.supportedModules$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final SensorsDataSDKVersionHelper getSdkVersionHelper() {
        Lazy lazy = this.sdkVersionHelper$delegate;
        return (SensorsDataSDKVersionHelper)lazy.getValue();
    }

    private final void checkDependency() {
        this.project.afterEvaluate(arg_0 -> SAPluginManager.checkDependency$lambda$0((Function1)new Function1<Project, Unit>(this){
            final /* synthetic */ SAPluginManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Project it) {
                if (!SAPluginManager.access$getProject$p(this.this$0).getPlugins().hasPlugin("com.android.application")) {
                    boolean bl = false;
                    String string = "SensorsData Android Plugin must used at Android App Project";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }, arg_0));
    }

    private final void createExtension() {
        Object object = this.project.getExtensions().create("sensorsAnalytics", SAExtension.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.creat\u2026 SAExtension::class.java)");
        this.setExtension((SAExtension)object);
    }

    private final void parseProperty() {
        Map map;
        Map $this$parseProperty_u24lambda_u241 = map = this.project.getProperties();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$parseProperty_u24lambda_u241, (String)"parseProperty$lambda$1");
        Map map2 = $this$parseProperty_u24lambda_u241;
        String string = "sensorsAnalytics.isHookOnMethodEnter";
        String string2 = "";
        String string3 = map2.getOrDefault(string, string2);
        Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type kotlin.String");
        String string4 = string3;
        this.isHookOnMethodEnter = Boolean.parseBoolean(string4);
        map2 = $this$parseProperty_u24lambda_u241;
        string = "sensorsAnalytics.isAndroidTv";
        string2 = "false";
        String string5 = map2.getOrDefault(string, string2);
        Intrinsics.checkNotNull((Object)string5, (String)"null cannot be cast to non-null type kotlin.String");
        string4 = string5;
        this.isAndroidTV = Boolean.parseBoolean(string4);
        map2 = $this$parseProperty_u24lambda_u241;
        string = "sensorsAnalytics.asmVersion";
        string2 = "ASM7";
        String string6 = map2.getOrDefault(string, string2);
        Intrinsics.checkNotNull((Object)string6, (String)"null cannot be cast to non-null type kotlin.String");
        this.asmVersion = string6;
        if (AGPVersion.Companion.getCURRENT_AGP_VERSION().compareTo(new AGPVersion(8, 0, 0)) >= 0) {
            this.asmVersion = "ASM9";
        }
    }

    private final void otherInit() {
        this.project.afterEvaluate(arg_0 -> SAPluginManager.otherInit$lambda$2((Function1)new Function1<Project, Unit>(this){
            final /* synthetic */ SAPluginManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Project it) {
                SAConfigHookHelper.Companion.initSDKConfigCells(this.this$0.getExtension());
                Logger.INSTANCE.setDebug(this.this$0.getExtension().getDebug());
            }
        }, arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int getASMVersion() {
        String string = this.asmVersion;
        switch (string.hashCode()) {
            case 2018622: {
                if (string.equals("ASM9")) return 589824;
                return 458752;
            }
            case 2018620: {
                if (string.equals("ASM7")) return 458752;
                return 458752;
            }
            case 2018621: {
                if (string.equals("ASM8")) return 524288;
                return 458752;
            }
            case 2018619: {
                if (!string.equals("ASM6")) return 458752;
                return 393216;
            }
        }
        return 458752;
    }

    @NotNull
    public final String getASMVersionStr$sa_gradle_plugin() {
        return this.asmVersion;
    }

    public final boolean isModuleEnable(@NotNull SAModule module) {
        Intrinsics.checkNotNullParameter((Object)((Object)module), (String)"module");
        return !this.getSupportedModules().contains((Object)module);
    }

    private static final void checkDependency$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void otherInit$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(SAPluginManager $this) {
        return $this.project;
    }
}

