/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.plugin.version;

import com.google.gson.JsonObject;
import com.sensorsdata.analytics.android.plugin.utils.TextUtil;

public class SensorsDataSDKVersionBean {
    private String mMinSensorsDataSDKVersion;
    private String mSensorsDataSDKPath;
    private String mMessage;

    public SensorsDataSDKVersionBean(String sensorsSDKPath, String minVersion, String message) {
        this.mSensorsDataSDKPath = sensorsSDKPath;
        this.mMinSensorsDataSDKVersion = minVersion;
        this.mMessage = message;
    }

    public String getSensorsDataSDKPath() {
        return this.mSensorsDataSDKPath;
    }

    public String getSensorsDataSDKVersionMessage(String version) {
        return !this.isVersionValid(version, this.mMinSensorsDataSDKVersion) ? String.format(TextUtil.isEmpty(this.mMessage) ? "\u5f53\u524d\u795e\u7b56 Android SDK \u7248\u672c %s \u8fc7\u4f4e\uff0c\u8bf7\u5347\u7ea7\u81f3 %s \u53ca\u5176\u4ee5\u4e0a\u7248\u672c\u540e\u8fdb\u884c\u4f7f\u7528" : this.mMessage, version, this.mMinSensorsDataSDKVersion) : "";
    }

    private boolean isVersionValid(String saVersion, String requiredVersion) {
        try {
            if (saVersion.equals(requiredVersion)) {
                return true;
            }
            String[] saVersions = saVersion.split("\\.");
            String[] requiredVersions = requiredVersion.split("\\.");
            for (int index = 0; index < requiredVersions.length; ++index) {
                int requiredVersionsNum;
                int saVersionsNum = Integer.parseInt(saVersions[index]);
                if (saVersionsNum == (requiredVersionsNum = Integer.parseInt(requiredVersions[index]))) continue;
                return saVersionsNum > requiredVersionsNum;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static SensorsDataSDKVersionBean createSensorDataSDKBean(JsonObject jsonObject) {
        if (null != jsonObject) {
            try {
                String path = jsonObject.get("SDK_VERSION_PATH").getAsString();
                String minVersion = jsonObject.get("DEPENDENT_MIN_SDK_VERSIONS").getAsString();
                if (!TextUtil.isEmpty(path) && !TextUtil.isEmpty(minVersion)) {
                    if (path.contains(".")) {
                        path = path.replaceAll("\\.", "/");
                    }
                    String message = jsonObject.get("ERROR_MESSAGE").getAsString();
                    return new SensorsDataSDKVersionBean(path, minVersion, message);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String toString() {
        return "\tminSensorsDataSDKVersion=" + this.mMinSensorsDataSDKVersion + "\n\tsensorsDataSDKPath=" + this.mSensorsDataSDKPath + "\n\tmessage=" + this.mMessage;
    }
}

