/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.plugin.push;

import com.sensorsdata.analytics.android.plugin.utils.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class SensorsPushInjected {
    public static final String PUSH_TRACK_OWNER = "com/sensorsdata/analytics/android/sdk/aop/push/PushAutoTrackHelper";

    public static void handlePush(MethodVisitor methodVisitor, String superName, String nameDesc) {
        if ("cn/jpush/android/service/JPushMessageReceiver".equals(superName) && "onNotifyMessageOpened(Landroid/content/Context;Lcn/jpush/android/api/NotificationMessage;)V".equals(nameDesc)) {
            SensorsPushInjected.handleJPush(methodVisitor);
        } else if ("onNotificationClicked(Landroid/content/Context;Lcom/meizu/cloud/pushsdk/handler/MzPushMessage;)V".equals(nameDesc) && "com/meizu/cloud/pushsdk/MzPushMessageReceiver".equals(superName)) {
            SensorsPushInjected.handleMeizuPush(methodVisitor);
        } else if ("com/igexin/sdk/GTIntentService".equals(superName)) {
            SensorsPushInjected.handleGTPush(methodVisitor, nameDesc);
        } else if ("com/umeng/message/UmengNotificationClickHandler".equals(superName)) {
            SensorsPushInjected.handleUmengNotificationClickHandler(methodVisitor, nameDesc);
        } else if ("com/umeng/message/UmengNotifyClickActivity".equals(superName) && "onMessage(Landroid/content/Intent;)V".equals(nameDesc)) {
            SensorsPushInjected.handleUmengNotifyClickActivity(methodVisitor);
        } else if ("onNewIntent(Landroid/content/Intent;)V".equals(nameDesc)) {
            SensorsPushInjected.handleOnNewIntent(methodVisitor, superName);
        } else if ("android/app/Service".equals(superName)) {
            SensorsPushInjected.handleCustomService(methodVisitor, nameDesc);
        } else if ("android/content/BroadcastReceiver".equals(superName)) {
            SensorsPushInjected.handleCustomBroadcast(methodVisitor, nameDesc);
        }
    }

    private static void handleJPush(MethodVisitor methodVisitor) {
        try {
            Label l1 = new Label();
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitJumpInsn(198, l1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitJumpInsn(198, l1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitFieldInsn(180, "cn/jpush/android/api/NotificationMessage", "notificationExtras", "Ljava/lang/String;");
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitFieldInsn(180, "cn/jpush/android/api/NotificationMessage", "notificationTitle", "Ljava/lang/String;");
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitFieldInsn(180, "cn/jpush/android/api/NotificationMessage", "notificationContent", "Ljava/lang/String;");
            methodVisitor.visitInsn(1);
            methodVisitor.visitMethodInsn(184, PUSH_TRACK_OWNER, "trackJPushAppOpenNotification", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", false);
            methodVisitor.visitLabel(l1);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void handleMeizuPush(MethodVisitor methodVisitor) {
        try {
            methodVisitor.visitVarInsn(25, 1);
            Label l1 = new Label();
            methodVisitor.visitJumpInsn(198, l1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitJumpInsn(198, l1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(182, "com/meizu/cloud/pushsdk/handler/MzPushMessage", "getSelfDefineContentString", "()Ljava/lang/String;", false);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(182, "com/meizu/cloud/pushsdk/handler/MzPushMessage", "getTitle", "()Ljava/lang/String;", false);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(182, "com/meizu/cloud/pushsdk/handler/MzPushMessage", "getContent", "()Ljava/lang/String;", false);
            methodVisitor.visitInsn(1);
            methodVisitor.visitMethodInsn(184, PUSH_TRACK_OWNER, "trackMeizuAppOpenNotification", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", false);
            methodVisitor.visitLabel(l1);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void handleGTPush(MethodVisitor methodVisitor, String nameDesc) {
        try {
            if ("onReceiveMessageData(Landroid/content/Context;Lcom/igexin/sdk/message/GTTransmitMessage;)V".equals(nameDesc)) {
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(184, PUSH_TRACK_OWNER, "onGeTuiReceiveMessageData", "(Ljava/lang/Object;)V", false);
            } else if ("onNotificationMessageClicked(Landroid/content/Context;Lcom/igexin/sdk/message/GTNotificationMessage;)V".equals(nameDesc)) {
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(184, PUSH_TRACK_OWNER, "onGeTuiNotificationClicked", "(Ljava/lang/Object;)V", false);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void handleUmengNotificationClickHandler(MethodVisitor methodVisitor, String nameDesc) {
        try {
            if ("openActivity(Landroid/content/Context;Lcom/umeng/message/entity/UMessage;)V".equals(nameDesc) || "dealWithCustomAction(Landroid/content/Context;Lcom/umeng/message/entity/UMessage;)V".equals(nameDesc) || "launchApp(Landroid/content/Context;Lcom/umeng/message/entity/UMessage;)V".equals(nameDesc) || "openUrl(Landroid/content/Context;Lcom/umeng/message/entity/UMessage;)V".equals(nameDesc)) {
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(184, PUSH_TRACK_OWNER, "onUMengNotificationClick", "(Ljava/lang/Object;)V", false);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void handleUmengNotifyClickActivity(MethodVisitor methodVisitor) {
        try {
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(184, PUSH_TRACK_OWNER, "onUMengActivityMessage", "(Landroid/content/Intent;)V", false);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void handleOnNewIntent(MethodVisitor methodVisitor, String superName) {
        try {
            if ("android/app/Activity".equals(superName)) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitMethodInsn(184, PUSH_TRACK_OWNER, "onNewIntent", "(Ljava/lang/Object;Landroid/content/Intent;)V", false);
            }
        }
        catch (Throwable throwable) {
            Logger.warn("Can not load class for [onNewIntent] hook, if you have any questions, please contact our technical services: classname:${className}, exception: ${throwable}");
        }
    }

    private static void handleCustomService(MethodVisitor methodVisitor, String nameDesc) {
        if ("onStart(Landroid/content/Intent;I)V".equals(nameDesc)) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(21, 2);
            methodVisitor.visitMethodInsn(184, PUSH_TRACK_OWNER, "onServiceStart", "(Landroid/app/Service;Landroid/content/Intent;I)V", false);
        } else if ("onStartCommand(Landroid/content/Intent;II)I".equals(nameDesc)) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(21, 2);
            methodVisitor.visitVarInsn(21, 3);
            methodVisitor.visitMethodInsn(184, PUSH_TRACK_OWNER, "onServiceStartCommand", "(Landroid/app/Service;Landroid/content/Intent;II)V", false);
        }
    }

    private static void handleCustomBroadcast(MethodVisitor methodVisitor, String nameDesc) {
        if ("onReceive(Landroid/content/Context;Landroid/content/Intent;)V".equals(nameDesc)) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(184, PUSH_TRACK_OWNER, "onBroadcastReceiver", "(Landroid/content/BroadcastReceiver;Landroid/content/Context;Landroid/content/Intent;)V", false);
        }
    }

    public static void addOnNewIntent(ClassVisitor classVisitor) {
        MethodVisitor mv = classVisitor.visitMethod(4, "onNewIntent", "(Landroid/content/Intent;)V", null, null);
        mv.visitAnnotation("Lcom/sensorsdata/analytics/android/sdk/SensorsDataInstrumented;", false);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "android/app/Activity", "onNewIntent", "(Landroid/content/Intent;)V", false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, PUSH_TRACK_OWNER, "onNewIntent", "(Ljava/lang/Object;Landroid/content/Intent;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }
}

