/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.receivers;

import android.content.Context;
import android.content.Intent;
import com.sensorberg.SensorbergSdk;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.SensorbergServiceIntents;
import com.sensorberg.sdk.receivers.SensorbergBroadcastReceiver;

public class ScannerBroadcastReceiver
extends SensorbergBroadcastReceiver {
    public static void setManifestReceiverEnabled(boolean enabled, Context context) {
        SensorbergBroadcastReceiver.setManifestReceiverEnabled(enabled, context, ScannerBroadcastReceiver.class);
    }

    public void onReceive(Context context, Intent intent) {
        if (SensorbergSdk.blocked()) {
            return;
        }
        String action = intent.getAction();
        if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
            int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
            switch (state) {
                case 13: {
                    this.stopScan(context);
                    break;
                }
                case 12: {
                    this.startScan(context);
                }
            }
            Logger.log.logBluetoothState(state);
        } else if (action.equals("android.intent.action.USER_PRESENT")) {
            this.pingScanner(context);
            Logger.log.userPresent();
        }
    }

    private void pingScanner(Context context) {
        Intent service = SensorbergServiceIntents.getPingIntent(context);
        this.startService(context, service);
    }

    private void startScan(Context context) {
        Intent service = SensorbergServiceIntents.getBluetoothMessageIntent(context, true);
        this.startService(context, service);
    }

    private void stopScan(Context context) {
        Intent service = SensorbergServiceIntents.getBluetoothMessageIntent(context, false);
        this.startService(context, service);
    }

    private void startService(Context context, Intent intent) {
        try {
            context.startService(intent);
        }
        catch (Exception ex) {
            Logger.log.logError("Couldn't start Sensorberg service in background", ex);
        }
    }
}

