/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.location;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import ch.hsr.geohash.GeoHash;

public class GeoHashLocation
extends Location {
    public static final float[] precision = new float[]{2.4f, 19.0f, 76.0f, 610.0f, 2400.0f, 20000.0f, 78000.0f, 630000.0f, 2500000.0f};
    private String geohash;
    public static final Parcelable.Creator<GeoHashLocation> CREATOR = new Parcelable.Creator<GeoHashLocation>(){

        public GeoHashLocation createFromParcel(Parcel in) {
            Location location = (Location)Location.CREATOR.createFromParcel(in);
            return new GeoHashLocation(location);
        }

        public GeoHashLocation[] newArray(int size) {
            return new GeoHashLocation[size];
        }
    };

    public GeoHashLocation(Location location) {
        super(location);
        for (int index = 0; index < precision.length; ++index) {
            if (!(location.getAccuracy() <= precision[index])) continue;
            this.geohash = GeoHash.geoHashStringWithCharacterPrecision((double)location.getLatitude(), (double)location.getLongitude(), (int)(precision.length - index));
            return;
        }
        this.geohash = GeoHash.geoHashStringWithCharacterPrecision((double)location.getLatitude(), (double)location.getLongitude(), (int)1);
    }

    public void writeToParcel(Parcel parcel, int flags) {
        super.writeToParcel(parcel, flags);
    }

    public String getGeohash() {
        return this.geohash;
    }
}

