/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal;

import android.content.Context;
import android.os.Build;

public class PermissionChecker {
    private final Context context;

    public PermissionChecker(Context context) {
        this.context = context;
    }

    public boolean hasVibratePermission() {
        return this.checkForPermission("android.permission.VIBRATE");
    }

    public boolean hasReadSyncSettingsPermissions() {
        return this.checkForPermission("android.permission.READ_SYNC_SETTINGS");
    }

    public boolean hasLocationPermission() {
        return this.checkForPermission("android.permission.ACCESS_COARSE_LOCATION") || this.checkForPermission("android.permission.ACCESS_FINE_LOCATION");
    }

    public boolean checkForPermission(String permissionIdentifier) {
        return this.context.checkCallingOrSelfPermission(permissionIdentifier) == 0;
    }

    public boolean hasScanPermissionCheckAndroid6() {
        if (Build.VERSION.SDK_INT <= 23) {
            return true;
        }
        return Build.VERSION.SDK_INT >= 23 && this.hasLocationPermission();
    }
}

