/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import com.sensorberg.SensorbergSdk;
import com.sensorberg.sdk.SensorbergServiceIntents;
import com.sensorberg.sdk.internal.PermissionChecker;
import com.sensorberg.sdk.internal.interfaces.Platform;
import javax.inject.Inject;

@TargetApi(value=14)
public class BackgroundDetector
implements Application.ActivityLifecycleCallbacks {
    private final Runnable FOREGROUND = new Runnable(){

        @Override
        public void run() {
            if (!BackgroundDetector.this.appForeGroundState && BackgroundDetector.this.isInForeground) {
                BackgroundDetector.this.appForeGroundState = true;
                BackgroundDetector.this.foregroundStateListener.hostApplicationInForeground();
            }
        }
    };
    private final Runnable BACKGROUND = new Runnable(){

        @Override
        public void run() {
            if (!BackgroundDetector.this.isInForeground) {
                BackgroundDetector.this.appForeGroundState = false;
                BackgroundDetector.this.foregroundStateListener.hostApplicationInBackground();
            }
        }
    };
    private final Handler handler;
    private boolean isInForeground;
    private boolean appForeGroundState = this.isInForeground = false;
    private Platform.ForegroundStateListener foregroundStateListener = Platform.ForegroundStateListener.NONE;
    @Inject
    protected PermissionChecker permissionChecker;
    private boolean hasPermission;

    public BackgroundDetector(Platform.ForegroundStateListener foregroundStateListener) {
        if (SensorbergSdk.blocked()) {
            this.handler = null;
            return;
        }
        this.handler = new Handler();
        this.foregroundStateListener = foregroundStateListener;
        SensorbergSdk.getComponent().inject(this);
        this.hasPermission = this.permissionChecker.hasScanPermissionCheckAndroid6();
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        if (SensorbergSdk.blocked()) {
            return;
        }
        this.handler.removeCallbacksAndMessages(null);
        this.isInForeground = true;
        this.handler.postDelayed(this.FOREGROUND, 500L);
        if (!this.hasPermission && this.permissionChecker.hasScanPermissionCheckAndroid6()) {
            this.hasPermission = true;
            activity.startService(SensorbergServiceIntents.getPingIntent((Context)activity));
        }
    }

    public void onActivityPaused(Activity activity) {
        if (SensorbergSdk.blocked()) {
            return;
        }
        this.handler.removeCallbacksAndMessages(null);
        this.isInForeground = false;
        this.handler.postDelayed(this.BACKGROUND, 500L);
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

