/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.location;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationServices;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.PermissionChecker;
import com.sensorberg.sdk.location.LocationHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PlayServiceManager {
    private static final long SERVICE_RECONNECT_INTERVAL = 900000L;
    private boolean retry = false;
    private List<GoogleApiClient.ConnectionCallbacks> listeners = new ArrayList<GoogleApiClient.ConnectionCallbacks>();
    private Context context;
    private PermissionChecker checker;
    private LocationHelper location;
    private GoogleApiClient client;
    private GoogleApiAvailability availability;
    private int logged = 0;
    private Handler handler;
    private int status;
    private final GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

        public void onConnected(@Nullable Bundle bundle) {
            for (GoogleApiClient.ConnectionCallbacks listener : PlayServiceManager.this.listeners) {
                listener.onConnected(bundle);
            }
        }

        public void onConnectionSuspended(int i) {
        }
    };
    private final GoogleApiClient.OnConnectionFailedListener connectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            Logger.log.geofenceError("Could not connect to Google Services API: " + connectionResult.getErrorMessage() + " code: " + connectionResult.getErrorCode(), null);
        }
    };

    public PlayServiceManager(Context context, LocationHelper location, PermissionChecker checker) {
        this.context = context;
        this.location = location;
        this.checker = checker;
        this.availability = GoogleApiAvailability.getInstance();
        this.status = this.availability.isGooglePlayServicesAvailable(context);
        this.client = new GoogleApiClient.Builder(context).addConnectionCallbacks(this.connectionCallbacks).addOnConnectionFailedListener(this.connectionFailedListener).addApi(LocationServices.API).build();
        if (this.status != 0) {
            Logger.log.geofenceError("Google Api Client status: " + this.status + " message: " + this.availability.getErrorString(this.status), null);
        }
        this.handler = new Handler(Looper.getMainLooper());
    }

    public GoogleApiClient getClient() {
        return this.client;
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public boolean isGeofencingAvailable() {
        this.status = this.availability.isGooglePlayServicesAvailable(this.context);
        return this.checker.checkForPermission("android.permission.ACCESS_FINE_LOCATION") && this.location.isLocationEnabled() && (this.status == 0 || this.status == 18);
    }

    public boolean connect() {
        this.status = this.availability.isGooglePlayServicesAvailable(this.context);
        switch (this.status) {
            case 0: {
                if (!this.client.isConnected() && !this.client.isConnecting()) {
                    this.retry(0L);
                }
                return true;
            }
            case 18: {
                Logger.log.geofenceError("Google Api Client " + this.availability.getErrorString(this.status), null);
                this.retry(900000L);
                return true;
            }
        }
        if (this.logged != this.status) {
            this.logged = this.status;
            Logger.log.geofenceError("Google Api Client " + this.availability.getErrorString(this.status), null);
        }
        return false;
    }

    public boolean disconnect() {
        this.handler.removeCallbacksAndMessages(null);
        this.retry = false;
        if (this.client.isConnected()) {
            this.client.disconnect();
            Logger.log.geofence("Google Api Client disconnected");
        }
        return true;
    }

    private void retry(long delay) {
        if (!this.retry) {
            this.retry = true;
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PlayServiceManager.this.client.connect();
                    Logger.log.geofence("Google Api Client connecting...");
                    PlayServiceManager.this.retry = false;
                }
            }, delay);
        }
    }

    public void addListener(GoogleApiClient.ConnectionCallbacks listener) {
        for (GoogleApiClient.ConnectionCallbacks previous : this.listeners) {
            if (previous != listener) continue;
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(GoogleApiClient.ConnectionCallbacks listener) {
        Iterator<GoogleApiClient.ConnectionCallbacks> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            GoogleApiClient.ConnectionCallbacks existing = iterator.next();
            if (existing != listener) continue;
            iterator.remove();
            return;
        }
    }

    public int getStatus() {
        return this.status;
    }
}

