/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.os.Process;
import android.text.TextUtils;
import com.sensorberg.SensorbergSdkEventListener;
import com.sensorberg.di.Component;
import com.sensorberg.sdk.Conversion;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.SensorbergServiceIntents;
import com.sensorberg.sdk.internal.interfaces.BluetoothPlatform;
import com.sensorberg.sdk.internal.interfaces.Platform;
import com.sensorberg.sdk.receivers.ScannerBroadcastReceiver;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.utils.AttributeValidator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import net.danlew.android.joda.JodaTimeAndroid;

public class SensorbergSdk
implements Platform.ForegroundStateListener {
    protected static Context context;
    protected boolean presentationDelegationEnabled;
    protected final Messenger messenger = new Messenger((Handler)new IncomingHandler());
    protected static final Set<SensorbergSdkEventListener> listeners;
    private static Component component;
    @Inject
    @Named(value="androidBluetoothPlatform")
    protected BluetoothPlatform bluetoothPlatform;

    public SensorbergSdk(Context ctx, String apiKey) {
        SensorbergSdk.init(ctx);
        SensorbergSdk.getComponent().inject(this);
        this.activateService(apiKey);
    }

    public static void init(Context ctx) {
        context = ctx;
        SensorbergSdk.initLibraries(context);
    }

    public static Component getComponent() {
        SensorbergSdk.buildComponentAndInject(context);
        return component;
    }

    private static void buildComponentAndInject(Context context) {
        if (component == null && context != null) {
            component = Component.Initializer.init((Application)context.getApplicationContext());
        }
    }

    private static synchronized void initLibraries(Context ctx) {
        if (ctx != null) {
            JodaTimeAndroid.init((Context)ctx);
        }
    }

    public void registerEventListener(SensorbergSdkEventListener listener) {
        if (SensorbergSdk.isSensorbergProcess(context)) {
            return;
        }
        if (listener != null) {
            listeners.add(listener);
        }
        if (!listeners.isEmpty() && !this.isPresentationDelegationEnabled()) {
            this.setPresentationDelegationEnabled(true);
        }
    }

    public void unregisterEventListener(SensorbergSdkEventListener listener) {
        listeners.remove(listener);
        if (listeners.isEmpty() && this.isPresentationDelegationEnabled()) {
            this.setPresentationDelegationEnabled(false);
        }
    }

    protected void setPresentationDelegationEnabled(boolean value) {
        this.presentationDelegationEnabled = value;
        if (value) {
            this.registerForPresentationDelegation();
        } else {
            this.unRegisterFromPresentationDelegation();
        }
    }

    protected static void notifyEventListeners(BeaconEvent beaconEvent) {
        for (SensorbergSdkEventListener listener : listeners) {
            listener.presentBeaconEvent(beaconEvent);
        }
    }

    protected void activateService(String apiKey) {
        if (this.bluetoothPlatform.isBluetoothLowEnergySupported()) {
            context.startService(SensorbergServiceIntents.getStartServiceIntent(context, apiKey));
        }
    }

    public void enableService(Context context, String apiKey) {
        ScannerBroadcastReceiver.setManifestReceiverEnabled(true, context);
        this.activateService(apiKey);
        this.hostApplicationInForeground();
    }

    public void disableService(Context context) {
        context.startService(SensorbergServiceIntents.getShutdownServiceIntent(context));
    }

    @Override
    public void hostApplicationInBackground() {
        Logger.log.applicationStateChanged("hostApplicationInBackground");
        context.startService(SensorbergServiceIntents.getAppInBackgroundIntent(context));
        this.unRegisterFromPresentationDelegation();
    }

    @Override
    public void hostApplicationInForeground() {
        context.startService(SensorbergServiceIntents.getAppInForegroundIntent(context));
        if (this.presentationDelegationEnabled) {
            this.registerForPresentationDelegation();
        }
    }

    protected void unRegisterFromPresentationDelegation() {
        context.startService(SensorbergServiceIntents.getIntentWithReplyToMessenger(context, 101, this.messenger));
    }

    protected void registerForPresentationDelegation() {
        context.startService(SensorbergServiceIntents.getIntentWithReplyToMessenger(context, 100, this.messenger));
    }

    public void changeAPIToken(String newApiToken) {
        if (!TextUtils.isEmpty((CharSequence)newApiToken)) {
            context.startService(SensorbergServiceIntents.getApiTokenIntent(context, newApiToken));
        } else {
            Logger.log.logError("Cannot set empty token");
        }
    }

    public void setAdvertisingIdentifier(String advertisingIdentifier) {
        Intent service = SensorbergServiceIntents.getAdvertisingIdentifierIntent(context, advertisingIdentifier);
        context.startService(service);
    }

    public void setLogging(boolean enableLogging) {
        context.startService(SensorbergServiceIntents.getServiceLoggingIntent(context, enableLogging));
    }

    public void sendLocationFlagToReceiver(int flagType) {
        Intent intent = new Intent();
        intent.setAction("com.sensorberg.android.sdk.intent.permissionState");
        intent.putExtra("type", flagType);
        context.sendBroadcast(intent);
    }

    public static void notifyConversionStatus(Context context, String actionInstanceUuid, Conversion conversion) {
        Intent intent = SensorbergServiceIntents.getConversionIntent(context, actionInstanceUuid, conversion.getValue());
        context.startService(intent);
    }

    public static void setAttributes(Map<String, String> attributes) throws IllegalArgumentException {
        HashMap<String, String> map = attributes != null ? new HashMap<String, String>(attributes) : new HashMap();
        if (!AttributeValidator.isInputValid(map)) {
            throw new IllegalArgumentException("Attributes can contain only alphanumerical characters and underscore");
        }
        Intent intent = SensorbergServiceIntents.getServiceIntentWithMessage(context, 300);
        intent.putExtra("com.sensorberg.android.sdk.intent.attributes", map);
        context.startService(intent);
    }

    public static boolean isSensorbergProcess(Context context) {
        String processName = "";
        int pID = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List processes = activityManager.getRunningAppProcesses();
        if (processes == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo processInfo : processes) {
            if (processInfo.pid != pID) continue;
            processName = processInfo.processName;
            break;
        }
        return processName.endsWith(":sensorberg");
    }

    public boolean isPresentationDelegationEnabled() {
        return this.presentationDelegationEnabled;
    }

    public static void setComponent(Component component) {
        SensorbergSdk.component = component;
    }

    static {
        listeners = new HashSet<SensorbergSdkEventListener>();
    }

    static class IncomingHandler
    extends Handler {
        IncomingHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 4: {
                    Bundle bundle = msg.getData();
                    bundle.setClassLoader(BeaconEvent.class.getClassLoader());
                    BeaconEvent beaconEvent = (BeaconEvent)bundle.getParcelable("com.sensorberg.android.sdk.message.presentBeaconEvent.beaconEvent");
                    SensorbergSdk.notifyEventListeners(beaconEvent);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }
}

