/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.resolver;

import android.os.Message;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.interfaces.BeaconResponseHandler;
import com.sensorberg.sdk.internal.interfaces.HandlerManager;
import com.sensorberg.sdk.internal.interfaces.RunLoop;
import com.sensorberg.sdk.internal.transport.interfaces.Transport;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.sdk.resolver.ResolverConfiguration;
import com.sensorberg.sdk.resolver.ResolverEvent;
import com.sensorberg.sdk.resolver.ResolverListener;
import com.sensorberg.sdk.scanner.ScanEvent;
import java.util.List;
import java.util.SortedMap;

public final class Resolver
implements RunLoop.MessageHandlerCallback {
    public final ResolverConfiguration configuration;
    private final Transport transport;
    private final RunLoop runLoop;
    protected SortedMap<String, String> attributes;
    private ResolverListener listener = ResolverListener.NONE;

    public Resolver(ResolverConfiguration configuration, HandlerManager handlerManager, Transport transport, SortedMap<String, String> attributes) {
        this.configuration = configuration;
        this.runLoop = handlerManager.getResolverRunLoop(this);
        this.transport = transport;
        transport.setApiToken(configuration.apiToken);
        this.attributes = attributes;
    }

    @Override
    public void handleMessage(Message queueEvent) {
        switch (queueEvent.arg1) {
            case 1: {
                ScanEvent scanEvent = (ScanEvent)queueEvent.obj;
                this.queryServer(scanEvent);
                break;
            }
            default: {
                throw new IllegalArgumentException("unhandled default case");
            }
        }
    }

    public void resolve(ScanEvent scanEvent) {
        this.runLoop.add(ResolverEvent.asMessage(1, scanEvent));
    }

    public void queryServer(final ScanEvent scanEvent) {
        Logger.log.beaconResolveState(scanEvent, "starting to resolve request");
        this.transport.getBeacon(scanEvent, this.attributes, new BeaconResponseHandler(){

            @Override
            public void onSuccess(List<BeaconEvent> beaconEvents) {
                Resolver.this.listener.onResolutionsFinished(beaconEvents);
                for (BeaconEvent beaconEvent : beaconEvents) {
                    Logger.log.beaconResolveState(scanEvent, "success resolving action:" + beaconEvent.getAction());
                }
            }

            @Override
            public void onFailure(Throwable throwable) {
                Resolver.this.listener.onResolutionFailed(throwable, scanEvent);
            }
        });
    }

    public void setAttributes(SortedMap<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setListener(ResolverListener listener) {
        this.listener = listener;
    }
}

