/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.location;

import android.location.Location;
import android.location.LocationManager;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.location.GeoHashLocation;
import com.sensorberg.sdk.settings.SettingsManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class LocationHelper {
    private LocationManager manager;
    private SettingsManager settings;
    private GeoHashLocation location;
    private final Comparator<Location> timeComparator = new Comparator<Location>(){

        @Override
        public int compare(Location t1, Location t2) {
            if (t1.getTime() > t2.getTime()) {
                return -1;
            }
            if (t2.getTime() > t1.getTime()) {
                return 1;
            }
            return 0;
        }
    };

    public LocationHelper(LocationManager manager, SettingsManager settings) {
        this.manager = manager;
        this.settings = settings;
    }

    public String getGeohash() {
        this.location = this.acquireGeohash();
        if (this.location != null) {
            return this.location.getGeohash();
        }
        return null;
    }

    public boolean isLocationEnabled() {
        for (String provider : this.manager.getProviders(true)) {
            if (!"gps".equals(provider) && !"network".equals(provider)) continue;
            return true;
        }
        return false;
    }

    private GeoHashLocation acquireGeohash() {
        ArrayList<Location> locations = new ArrayList<Location>(3);
        if (this.isAccurateAndFreshAndNotNull(this.location)) {
            locations.add(this.location);
        }
        List providers = this.manager.getProviders(true);
        int size = providers.size();
        for (int i = 0; i < size; ++i) {
            String provider = (String)providers.get(i);
            try {
                Location location = this.manager.getLastKnownLocation(provider);
                if (!this.isAccurateAndFreshAndNotNull(location)) continue;
                locations.add(location);
                continue;
            }
            catch (SecurityException ex) {
                Logger.log.logError("Missing permission for " + provider + " provider", ex);
            }
        }
        Location freshest = null;
        if (locations.size() > 1) {
            Collections.sort(locations, this.timeComparator);
        }
        if (locations.size() > 0) {
            freshest = (Location)locations.get(0);
        }
        if (freshest instanceof GeoHashLocation) {
            return (GeoHashLocation)freshest;
        }
        return freshest == null ? null : new GeoHashLocation(freshest);
    }

    public long getMaxLocationAge() {
        return this.settings.getGeohashMaxAge();
    }

    public int getGeohashMinAccuracyRadius() {
        return this.settings.getGeohashMinAccuracyRadius();
    }

    private boolean isAccurateAndFreshAndNotNull(Location location) {
        return location != null && location.getAccuracy() < (float)this.getGeohashMinAccuracyRadius() && System.currentTimeMillis() - location.getTime() < this.getMaxLocationAge();
    }
}

