/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.location;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.location.LocationManager;
import android.os.Parcelable;
import com.google.android.gms.location.GeofencingEvent;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationResult;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.SensorbergServiceIntents;
import com.sensorberg.sdk.location.GeofenceData;
import java.util.List;

public class GeofenceReceiver
extends BroadcastReceiver {
    public static final String ACTION_GEOFENCE = "com.sensorberg.sdk.receiver.GEOFENCE";
    public static final String ACTION_LOCATION_UPDATE = "com.sensorberg.sdk.receiver.LOCATION_UPDATE";

    public static PendingIntent getGeofencePendingIntent(Context context) {
        Intent intent = new Intent(context, GeofenceReceiver.class);
        intent.setAction(ACTION_GEOFENCE);
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0x8000000);
    }

    public static PendingIntent getLocationPendingIntent(Context context) {
        Intent intent = new Intent(context, GeofenceReceiver.class);
        intent.setAction(ACTION_LOCATION_UPDATE);
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0x8000000);
    }

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action == null || action.isEmpty()) {
            Logger.log.geofenceError("Received intent without action", null);
            return;
        }
        switch (action) {
            case "com.sensorberg.sdk.receiver.GEOFENCE": {
                this.handleGeofence(context, intent);
                break;
            }
            case "com.sensorberg.sdk.receiver.LOCATION_UPDATE": {
                this.handleLocationUpdate(context, intent);
                break;
            }
            case "android.location.PROVIDERS_CHANGED": {
                this.handleProvidersChanged(context);
                break;
            }
            default: {
                Logger.log.geofenceError("Received intent with unknown action " + action, null);
            }
        }
    }

    private boolean isLocationEnabled(LocationManager locationManager) {
        for (String provider : locationManager.getProviders(true)) {
            if (!"gps".equals(provider) && !"network".equals(provider)) continue;
            return true;
        }
        return false;
    }

    private void handleProvidersChanged(Context context) {
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        if (this.isLocationEnabled(locationManager)) {
            Intent service = SensorbergServiceIntents.getServiceIntentWithMessage(context, 601);
            context.startService(service);
        }
    }

    private void handleLocationUpdate(Context context, Intent intent) {
        Location location;
        LocationResult result = LocationResult.extractResult((Intent)intent);
        LocationAvailability availability = LocationAvailability.extractLocationAvailability((Intent)intent);
        Intent service = SensorbergServiceIntents.getServiceIntentWithMessage(context, 600);
        if (result != null && (location = result.getLastLocation()) != null) {
            service.putExtra("com.sensorberg.android.sdk.intent.geofence.location", (Parcelable)location);
        }
        if (availability != null) {
            service.putExtra("com.sensorberg.android.sdk.intent.geofence.location.availability", availability.isLocationAvailable());
        }
        if (result != null || availability != null) {
            context.startService(service);
        } else {
            Logger.log.geofenceError("Received invalid location update", null);
        }
    }

    private void handleGeofence(Context context, Intent intent) {
        GeofencingEvent event = GeofencingEvent.fromIntent((Intent)intent);
        if (event == null) {
            Logger.log.geofenceError("GeofencingEvent is null", null);
            return;
        }
        if (event.hasError() && event.getErrorCode() == 1000) {
            Logger.log.geofence("Received GEOFENCE_NOT_AVAILABLE from service, will re-register");
            Intent service = SensorbergServiceIntents.getServiceIntentWithMessage(context, 401);
            context.startService(service);
            return;
        }
        try {
            List<GeofenceData> geofenceDatas = GeofenceData.from(event);
            boolean entry = event.getGeofenceTransition() == 1;
            for (GeofenceData geofenceData : geofenceDatas) {
                Logger.log.geofence("Received " + (entry ? "entry" : "exit") + " event " + geofenceData.getGeohash() + ", radius " + geofenceData.getRadius());
                Intent service = SensorbergServiceIntents.getServiceIntentWithMessage(context, 400);
                service.putExtra("com.sensorberg.android.sdk.intent.geofence.data", (Parcelable)geofenceData);
                service.putExtra("com.sensorberg.android.sdk.intent.geofence.entry", entry);
                context.startService(service);
            }
        }
        catch (IllegalArgumentException ex) {
            Logger.log.geofenceError("GeofencingEvent is invalid", ex);
        }
    }
}

