/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk;

import com.sensorberg.sdk.model.BeaconId;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.sdk.scanner.ScanEvent;
import java.util.HashMap;
import java.util.Map;

public class Logger {
    public static Log log;
    private static final String TAG = "Sensorberg";
    public static final Log QUIET_LOG;

    public static boolean isVerboseLoggingEnabled() {
        return log != QUIET_LOG;
    }

    public static void enableVerboseLogging() {
        log = new VerboseLogger();
    }

    static {
        QUIET_LOG = new Log(){

            @Override
            public void beaconResolveState(ScanEvent event, String state) {
            }

            @Override
            public void beaconResolveState(BeaconEvent event, String state) {
            }

            @Override
            public void beaconSeenAgain(BeaconId beaconId) {
            }

            @Override
            public void scannerStateChange(String state) {
            }

            @Override
            public void logBluetoothState(int state) {
            }

            @Override
            public void userPresent() {
            }

            @Override
            public void applicationStateChanged(String state) {
            }

            @Override
            public void serviceHandlesMessage(String message) {
            }

            @Override
            public void logError(String s, Throwable cause) {
            }

            @Override
            public void logError(String errorString) {
            }

            @Override
            public void logServiceState(String state) {
            }

            @Override
            public void logSettingsUpdateState(String state) {
            }

            @Override
            public void verbose(String message) {
            }

            @Override
            public void debug(String message) {
            }

            @Override
            public void logBeaconHistoryPublisherState(String s) {
            }

            @Override
            public void geofence(String s) {
            }

            @Override
            public void geofenceError(String s, Throwable cause) {
            }

            @Override
            public void logAttributes(String s) {
            }
        };
        log = "release".equalsIgnoreCase("debug") ? new VerboseLogger() : QUIET_LOG;
    }

    public static class VerboseLoggerSeenAgainSlowed
    extends VerboseLogger {
        private final Map<BeaconId, Integer> counter = new HashMap<BeaconId, Integer>();
        private final int countNeeded;

        public VerboseLoggerSeenAgainSlowed(int countNeeded) {
            this.countNeeded = countNeeded;
        }

        @Override
        public void beaconSeenAgain(BeaconId beaconId) {
            Integer value = this.counter.get(beaconId);
            if (value == null) {
                value = 1;
            }
            this.counter.put(beaconId, value);
            if (this.counter.get(beaconId) % this.countNeeded == 0) {
                android.util.Log.d((String)Logger.TAG, (String)(beaconId.toTraditionalString() + " was seen again "));
            }
        }
    }

    static class VerboseLogger
    implements Log {
        VerboseLogger() {
        }

        @Override
        public void beaconResolveState(ScanEvent event, String state) {
            android.util.Log.d((String)Logger.TAG, (String)(event.getBeaconId().toTraditionalString() + " has switched to state " + state));
        }

        @Override
        public void beaconResolveState(BeaconEvent event, String state) {
            android.util.Log.d((String)Logger.TAG, (String)("showing an action for a beacon scanevent " + event.getBeaconId().toTraditionalString() + " state " + state));
        }

        @Override
        public void beaconSeenAgain(BeaconId beaconId) {
            android.util.Log.d((String)Logger.TAG, (String)(beaconId.toTraditionalString() + " was seen again "));
        }

        @Override
        public void scannerStateChange(String state) {
            android.util.Log.d((String)Logger.TAG, (String)("scanner has changed state:" + state));
        }

        @Override
        public void serviceHandlesMessage(String message) {
            android.util.Log.d((String)Logger.TAG, (String)("service is handling message:" + message));
        }

        @Override
        public void logError(String s, Throwable cause) {
            if (cause != null) {
                this.logError(s + cause.getMessage());
            } else {
                this.logError(s);
            }
        }

        @Override
        public void logError(String s) {
            android.util.Log.e((String)Logger.TAG, (String)s);
        }

        @Override
        public void logServiceState(String state) {
            android.util.Log.d((String)Logger.TAG, (String)("service state:" + state));
        }

        @Override
        public void logSettingsUpdateState(String state) {
            android.util.Log.d((String)Logger.TAG, (String)("settings update finished message:\"" + state + "\""));
        }

        @Override
        public void verbose(String message) {
            android.util.Log.v((String)Logger.TAG, (String)message);
        }

        @Override
        public void debug(String message) {
            android.util.Log.d((String)Logger.TAG, (String)message);
        }

        @Override
        public void logBeaconHistoryPublisherState(String state) {
            android.util.Log.d((String)Logger.TAG, (String)("beaconHistoryPublisher state:" + state));
        }

        @Override
        public void geofence(String s) {
            android.util.Log.d((String)Logger.TAG, (String)("Geofences: " + s));
        }

        @Override
        public void geofenceError(String s, Throwable cause) {
            android.util.Log.e((String)Logger.TAG, (String)("Geofences: " + s), (Throwable)cause);
        }

        @Override
        public void logBluetoothState(int state) {
            switch (state) {
                case 10: {
                    android.util.Log.d((String)Logger.TAG, (String)"Bluetooth off");
                    break;
                }
                case 13: {
                    android.util.Log.d((String)Logger.TAG, (String)"Turning Bluetooth off... stopping scans");
                    break;
                }
                case 12: {
                    android.util.Log.d((String)Logger.TAG, (String)"Bluetooth on");
                    break;
                }
                case 11: {
                    android.util.Log.d((String)Logger.TAG, (String)"Turning Bluetooth on... restarting scans");
                }
            }
        }

        @Override
        public void userPresent() {
            android.util.Log.d((String)Logger.TAG, (String)"User present");
        }

        @Override
        public void applicationStateChanged(String message) {
            android.util.Log.d((String)Logger.TAG, (String)("application has changed state:" + message));
        }

        @Override
        public void logAttributes(String s) {
            android.util.Log.d((String)Logger.TAG, (String)("Attributes: " + s));
        }
    }

    public static interface Log {
        public void beaconResolveState(ScanEvent var1, String var2);

        public void beaconResolveState(BeaconEvent var1, String var2);

        public void beaconSeenAgain(BeaconId var1);

        public void logBluetoothState(int var1);

        public void userPresent();

        public void applicationStateChanged(String var1);

        public void scannerStateChange(String var1);

        public void serviceHandlesMessage(String var1);

        public void logError(String var1, Throwable var2);

        public void logError(String var1);

        public void logServiceState(String var1);

        public void logSettingsUpdateState(String var1);

        public void verbose(String var1);

        public void debug(String var1);

        public void logBeaconHistoryPublisherState(String var1);

        public void geofence(String var1);

        public void geofenceError(String var1, Throwable var2);

        public void logAttributes(String var1);
    }
}

