/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.scanner;

import com.sensorberg.sdk.internal.interfaces.FileManager;
import com.sensorberg.sdk.model.BeaconId;
import com.sensorberg.sdk.scanner.EventEntry;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BeaconMap {
    private FileManager fileManager;
    private final HashMap<BeaconId, EventEntry> storage;
    private final File fileForPersistance;

    public BeaconMap(FileManager fm, File file) {
        this.fileManager = fm;
        this.fileForPersistance = file;
        this.storage = this.fileForPersistance != null ? this.readBeaconEntriesFile(this.fileForPersistance) : new HashMap();
    }

    public int size() {
        return this.storage.size();
    }

    public void clear() {
        this.storage.clear();
        this.deleteFile();
    }

    private void deleteFile() {
        if (this.fileForPersistance != null) {
            this.fileForPersistance.delete();
        }
    }

    public EventEntry get(BeaconId beaconId) {
        return this.storage.get(beaconId);
    }

    public void put(BeaconId beaconId, EventEntry entry) {
        this.storage.put(beaconId, entry);
        this.persist();
    }

    public void addScanPauseTime(long pause) {
        for (Map.Entry<BeaconId, EventEntry> entry : this.storage.entrySet()) {
            this.storage.put(entry.getKey(), new EventEntry(entry.getValue().getLastBeaconTime(), entry.getValue().getScanPauseTime() + pause, entry.getValue().getEventMask(), entry.getValue().getPairingId()));
        }
    }

    public void filter(Filter filter) {
        boolean modified = false;
        Iterator<Map.Entry<BeaconId, EventEntry>> iterator = this.storage.entrySet().iterator();
        while (iterator.hasNext()) {
            BeaconId beaconId;
            Map.Entry<BeaconId, EventEntry> enteredBeacon = iterator.next();
            EventEntry beaconEntry = enteredBeacon.getValue();
            if (!filter.filter(beaconEntry, beaconId = enteredBeacon.getKey())) continue;
            iterator.remove();
            modified = true;
        }
        if (modified) {
            this.persist();
        }
    }

    private void persist() {
        if (this.fileForPersistance != null) {
            this.fileManager.write(this.storage, this.fileForPersistance);
        }
    }

    private HashMap<BeaconId, EventEntry> readBeaconEntriesFile(File file) {
        HashMap value;
        try {
            value = (HashMap)this.fileManager.getContentsOfFileOrNull(file);
            if (value == null) {
                return new HashMap<BeaconId, EventEntry>();
            }
        }
        catch (ClassCastException e) {
            return new HashMap<BeaconId, EventEntry>();
        }
        return value;
    }

    public static interface Filter {
        public boolean filter(EventEntry var1, BeaconId var2);
    }
}

