/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.scanner;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Message;
import android.util.Pair;
import com.sensorberg.SensorbergSdk;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.interfaces.BluetoothPlatform;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.internal.interfaces.FileManager;
import com.sensorberg.sdk.internal.interfaces.HandlerManager;
import com.sensorberg.sdk.internal.interfaces.Platform;
import com.sensorberg.sdk.internal.interfaces.RunLoop;
import com.sensorberg.sdk.internal.interfaces.ServiceScheduler;
import com.sensorberg.sdk.location.LocationHelper;
import com.sensorberg.sdk.model.BeaconId;
import com.sensorberg.sdk.scanner.BeaconMap;
import com.sensorberg.sdk.scanner.EventEntry;
import com.sensorberg.sdk.scanner.ScanEvent;
import com.sensorberg.sdk.scanner.ScanEventType;
import com.sensorberg.sdk.scanner.ScanHelper;
import com.sensorberg.sdk.scanner.ScannerEvent;
import com.sensorberg.sdk.scanner.ScannerListener;
import com.sensorberg.sdk.settings.SettingsManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import java.util.UUID;
import javax.inject.Inject;

public abstract class AbstractScanner
implements RunLoop.MessageHandlerCallback,
Platform.ForegroundStateListener {
    private static final long NEVER_STOPPED = 0L;
    long waitTime;
    long scanTime;
    private final SettingsManager settingsManager;
    private final Clock clock;
    private final ServiceScheduler serviceScheduler;
    private final BluetoothPlatform bluetoothPlatform;
    private final ScanCallback scanCallback = new ScanCallback();
    private final Object listenersMonitor = new Object();
    private final List<ScannerListener> listeners = new ArrayList<ScannerListener>();
    private final Object enteredBeaconsMonitor = new Object();
    private final BeaconMap enteredBeacons;
    private final RunLoop runLoop;
    private long lastStopTimestamp = 0L;
    private long started;
    private boolean scanning;
    private long lastExitCheckTimestamp;
    private long lastBreakLength = 0L;
    private long lastScanStart;
    @Inject
    LocationHelper locationHelper;
    private RssiListener rssiListener = RssiListener.NONE;

    AbstractScanner(SettingsManager stgMgr, boolean shouldRestoreBeaconStates, Clock clk, FileManager fileManager, ServiceScheduler scheduler, HandlerManager handlerManager, BluetoothPlatform btPlatform) {
        this.settingsManager = stgMgr;
        this.clock = clk;
        this.serviceScheduler = scheduler;
        this.scanning = false;
        this.runLoop = handlerManager.getScannerRunLoop(this);
        this.bluetoothPlatform = btPlatform;
        File beaconFile = shouldRestoreBeaconStates ? fileManager.getFile("enteredBeaconsCache") : null;
        this.enteredBeacons = new BeaconMap(fileManager, beaconFile);
        this.waitTime = this.settingsManager.getBackgroundWaitTime();
        this.scanTime = this.settingsManager.getBackgroundScanTime();
        SensorbergSdk.getComponent().inject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScannerListener(ScannerListener listener) {
        Object object = this.listenersMonitor;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndExitEnteredBeacons() {
        long now;
        this.lastExitCheckTimestamp = now = this.clock.now();
        Object object = this.enteredBeaconsMonitor;
        synchronized (object) {
            if (this.enteredBeacons.size() > 0) {
                this.enteredBeacons.filter(new BeaconMap.Filter(){

                    @Override
                    public boolean filter(EventEntry beaconEntry, BeaconId beaconId) {
                        long timeSinceWeSawTheBeacon = now - AbstractScanner.this.lastBreakLength - beaconEntry.getLastBeaconTime();
                        if (timeSinceWeSawTheBeacon > AbstractScanner.this.settingsManager.getExitTimeoutMillis()) {
                            ScanEvent scanEvent = new ScanEvent(beaconId, now, false, AbstractScanner.this.locationHelper.getGeohash(), beaconEntry.getPairingId());
                            AbstractScanner.this.runLoop.sendMessage(3, scanEvent);
                            Logger.log.beaconResolveState(scanEvent, " exited (time since we saw the beacon: " + (int)(timeSinceWeSawTheBeacon / 1000L) + " seconds)");
                            return true;
                        }
                        return false;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Object object = this.enteredBeaconsMonitor;
        synchronized (object) {
            this.enteredBeacons.clear();
        }
    }

    public boolean isScanRunning() {
        return this.scanning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (this.settingsManager.getScannerMinRssi() != Integer.MIN_VALUE && rssi < this.settingsManager.getScannerMinRssi()) {
            return;
        }
        Pair<BeaconId, Integer> beacon = ScanHelper.getBeaconID(scanRecord);
        if (beacon != null) {
            int calRssi = (Integer)beacon.second;
            if (this.settingsManager.getScannerMaxDistance() != Integer.MAX_VALUE && AbstractScanner.getDistanceFromRSSI(rssi, calRssi) > (double)this.settingsManager.getScannerMaxDistance()) {
                return;
            }
            BeaconId beaconId = (BeaconId)beacon.first;
            Object object = this.enteredBeaconsMonitor;
            synchronized (object) {
                long now = this.clock.now();
                EventEntry entry = this.enteredBeacons.get(beaconId);
                if (entry == null) {
                    String address = device != null ? device.getAddress() : null;
                    ScanEvent scanEvent = new ScanEvent(beaconId, now, true, address, rssi, calRssi, this.locationHelper.getGeohash(), UUID.randomUUID().toString());
                    this.runLoop.sendMessage(3, scanEvent);
                    entry = new EventEntry(now, ScanEventType.ENTRY.getMask(), scanEvent.getPairingId());
                    Logger.log.beaconResolveState(scanEvent, "entered");
                } else {
                    entry = new EventEntry(now, entry.getEventMask(), entry.getPairingId());
                    Logger.log.beaconSeenAgain(beaconId);
                    if (this.rssiListener != RssiListener.NONE) {
                        this.runLoop.sendMessage(6, new Pair((Object)beaconId, (Object)rssi));
                    }
                }
                this.enteredBeacons.put(beaconId, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message message) {
        ScannerEvent queueEvent = new ScannerEvent(message.what, message.obj);
        switch (queueEvent.getType()) {
            case 1: {
                if (this.scanning) break;
                this.lastExitCheckTimestamp = this.clock.now();
                if (this.lastStopTimestamp != 0L && this.lastExitCheckTimestamp - this.lastStopTimestamp > this.settingsManager.getCleanBeaconMapRestartTimeout()) {
                    this.clearCache();
                    Logger.log.scannerStateChange("clearing the currently seen beacon, since we were turned off too long.");
                }
                this.started = this.clock.now();
                this.scanning = true;
                this.runLoop.sendMessage(5);
                break;
            }
            case 4: {
                this.bluetoothPlatform.stopLeScan();
                Logger.log.scannerStateChange("sleeping for" + this.waitTime + "millis");
                this.scheduleExecution(5, this.waitTime);
                this.runLoop.cancelFixedRateExecution();
                break;
            }
            case 5: {
                this.lastScanStart = this.clock.now();
                this.lastBreakLength = this.clock.now() - this.lastExitCheckTimestamp;
                Logger.log.scannerStateChange("starting to scan again, scan break was " + this.lastBreakLength + "millis");
                if (!this.scanning) break;
                Logger.log.debug("ScannerStatusUnpause" + Boolean.toString(this.scanning));
                Logger.log.scannerStateChange("scanning for" + this.scanTime + "millis");
                this.bluetoothPlatform.startLeScan(this.scanCallback);
                this.scheduleExecution(4, this.scanTime);
                this.runLoop.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        AbstractScanner.this.loop();
                    }
                }, 0, 1000L);
                break;
            }
            case 2: {
                this.started = 0L;
                this.scanning = false;
                this.clearScheduledExecutions();
                this.bluetoothPlatform.stopLeScan();
                this.lastStopTimestamp = this.clock.now();
                this.runLoop.cancelFixedRateExecution();
                Logger.log.scannerStateChange("scan stopped");
                break;
            }
            case 3: {
                ScanEvent scanEvent = (ScanEvent)queueEvent.getData();
                Object object = this.listenersMonitor;
                synchronized (object) {
                    for (ScannerListener listener : this.listeners) {
                        listener.onScanEventDetected(scanEvent);
                    }
                    break;
                }
            }
            case 6: {
                Pair value = (Pair)queueEvent.getData();
                this.rssiListener.onRssiUpdated((BeaconId)value.first, (Integer)value.second);
                break;
            }
            default: {
                throw new IllegalArgumentException("unhandled case " + queueEvent.getData());
            }
        }
    }

    protected abstract void clearScheduledExecutions();

    private void loop() {
        if (this.clock.now() > this.started + this.settingsManager.getExitTimeoutMillis() && this.bluetoothPlatform.isLeScanRunning()) {
            this.checkAndExitEnteredBeacons();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScannerListener(ScannerListener listener) {
        Object object = this.listenersMonitor;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    public void start() {
        Logger.log.debug("Scan: Scanner started");
        this.runLoop.sendMessage(1);
    }

    public void stop() {
        Logger.log.debug("Scan: Scanner stopped");
        this.runLoop.sendMessage(2);
    }

    @Override
    public void hostApplicationInForeground() {
        if (this.isNotSetupForForegroundScanning()) {
            this.waitTime = this.settingsManager.getForeGroundWaitTime();
            this.scanTime = this.settingsManager.getForeGroundScanTime();
            if (this.scanning) {
                long lastWaitTime = this.clock.now() - this.lastExitCheckTimestamp;
                this.clearScheduledExecutions();
                if (lastWaitTime > this.waitTime) {
                    Logger.log.scannerStateChange("We have been waiting longer than the foreground wait time, so we\u00b4e going to scan right away");
                    this.runLoop.sendMessage(5);
                } else {
                    long timeRemainingToWait = this.waitTime - lastWaitTime;
                    Logger.log.scannerStateChange("We have been waiting longer than the foreground wait time, so we\u00b4e going to scan in " + timeRemainingToWait + " millis");
                    this.scheduleExecution(5, this.waitTime - lastWaitTime);
                }
            }
        }
    }

    abstract void scheduleExecution(int var1, long var2);

    private boolean isNotSetupForForegroundScanning() {
        return this.waitTime != this.settingsManager.getForeGroundWaitTime() || this.scanTime != this.settingsManager.getForeGroundScanTime();
    }

    @Override
    public void hostApplicationInBackground() {
        this.waitTime = this.settingsManager.getBackgroundWaitTime();
        this.scanTime = this.settingsManager.getBackgroundScanTime();
        if (this.clock.now() - this.lastScanStart > this.scanTime) {
            Logger.log.scannerStateChange("We have been scanning longer than the background scan, so we\u00b4e going to pause right away");
            this.clearScheduledExecutions();
            this.runLoop.sendMessage(4);
        }
    }

    private static double getDistanceFromRSSI(double rssi, int calRssi) {
        double near = rssi / (double)calRssi;
        double dist = near < 1.0 ? Math.pow(near, 10.0) : (double)0.89976f * Math.pow(near, 7.7095f) + (double)0.111f;
        return dist;
    }

    public ServiceScheduler getServiceScheduler() {
        return this.serviceScheduler;
    }

    public RunLoop getRunLoop() {
        return this.runLoop;
    }

    public RssiListener getRssiListener() {
        return this.rssiListener;
    }

    public void setRssiListener(RssiListener rssiListener) {
        this.rssiListener = rssiListener;
    }

    public static interface RssiListener {
        public static final RssiListener NONE = new RssiListener(){

            @Override
            public void onRssiUpdated(BeaconId beaconId, Integer rssiValue) {
            }
        };

        public void onRssiUpdated(BeaconId var1, Integer var2);
    }

    @TargetApi(value=18)
    private class ScanCallback
    implements BluetoothAdapter.LeScanCallback {
        private ScanCallback() {
        }

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            AbstractScanner.this.onLeScan(device, rssi, scanRecord);
        }
    }
}

