/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.model.persistence;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.sensorberg.sdk.scanner.ScanEvent;
import com.sensorberg.sdk.scanner.ScanEventType;
import com.sensorberg.utils.Objects;

public class BeaconScan {
    public static final String SHARED_PREFS_TAG = "com.sensorberg.sdk.BeaconScan";
    @Expose
    @SerializedName(value="trigger")
    private int trigger;
    @Expose
    @SerializedName(value="pid")
    private String pid;
    @Expose
    @SerializedName(value="dt")
    private long createdAt;
    @Expose
    @SerializedName(value="location")
    private String geohash;
    @Expose
    @SerializedName(value="pairingId")
    private String pairingId;

    public static BeaconScan from(ScanEvent scanEvent) {
        BeaconScan value = new BeaconScan();
        value.setTrigger(scanEvent.isEntry() ? ScanEventType.ENTRY.getMask() : ScanEventType.EXIT.getMask());
        if (scanEvent.getBeaconId().getGeofenceData() == null) {
            value.setPid(scanEvent.getBeaconId().getPid());
        } else {
            value.setPid(scanEvent.getBeaconId().getGeofenceData().getFence());
        }
        value.setCreatedAt(scanEvent.getEventTime());
        value.setGeohash(scanEvent.getGeohash());
        value.setPairingId(scanEvent.getPairingId());
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconScan that = (BeaconScan)o;
        if (this.trigger != that.trigger) {
            return false;
        }
        if (this.createdAt != that.createdAt) {
            return false;
        }
        if (!Objects.equals(this.geohash, that.geohash)) {
            return false;
        }
        if (!Objects.equals(this.pairingId, that.pairingId)) {
            return false;
        }
        return !(this.pid == null ? that.pid != null : !this.pid.equals(that.pid));
    }

    public int hashCode() {
        int result = this.trigger;
        result = 31 * result + (this.pid != null ? this.pid.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (this.geohash != null ? this.geohash.hashCode() : 0);
        result = 31 * result + (this.pairingId != null ? this.pairingId.hashCode() : 0);
        return result;
    }

    public int getTrigger() {
        return this.trigger;
    }

    public void setTrigger(int trigger) {
        this.trigger = trigger;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public String getGeohash() {
        return this.geohash;
    }

    public void setGeohash(String geohash) {
        this.geohash = geohash;
    }

    public String getPairingId() {
        return this.pairingId;
    }

    public void setPairingId(String pairingId) {
        this.pairingId = pairingId;
    }
}

