/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal;

import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.PendingIntentStorage;
import com.sensorberg.sdk.internal.PersistentIntegerCounter;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.internal.interfaces.MessageDelayWindowLengthListener;
import com.sensorberg.sdk.internal.interfaces.ServiceScheduler;
import com.sensorberg.sdk.receivers.GenericBroadcastReceiver;
import com.sensorberg.sdk.resolver.BeaconEvent;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class AndroidServiceScheduler
implements ServiceScheduler,
MessageDelayWindowLengthListener {
    private final Context context;
    private final AlarmManager alarmManager;
    private final Clock clock;
    private final PersistentIntegerCounter postToServiceCounter;
    private long messageDelayWindowLength;
    private final Set<Integer> repeatingPendingIntents = new HashSet<Integer>();
    private final PendingIntentStorage pendingIntentStorage;

    public AndroidServiceScheduler(Context ctx, AlarmManager am, Clock clk, PersistentIntegerCounter integerCounter, long defaultMessageDelayWindowLength) {
        this.context = ctx;
        this.alarmManager = am;
        this.clock = clk;
        this.postToServiceCounter = integerCounter;
        this.messageDelayWindowLength = defaultMessageDelayWindowLength;
        this.pendingIntentStorage = new PendingIntentStorage(this, this.clock);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void scheduleIntent(long index, long delayInMillis, Bundle content) {
        PendingIntent pendingIntent = this.getPendingIntent(index, content);
        this.scheduleAlarm(delayInMillis, pendingIntent);
    }

    @Override
    public void unscheduleIntent(int index) {
        this.alarmManager.cancel(this.getPendingIntent(index, null));
    }

    private PendingIntent getPendingIntent(int MSG_type) {
        Intent intent = new Intent(this.context, GenericBroadcastReceiver.class);
        intent.putExtra("com.sensorberg.android.sdk.intent.generic.type", MSG_type);
        intent.setAction("broadcast_repeating:///message_" + MSG_type);
        return PendingIntent.getBroadcast((Context)this.context, (int)-1, (Intent)intent, (int)0x8000000);
    }

    private PendingIntent getPendingIntent(long index, Bundle extras) {
        return this.getPendingIntent(index, extras, "");
    }

    private PendingIntent getPendingIntent(long index, Bundle extras, String prefix) {
        Intent intent = new Intent(this.context, GenericBroadcastReceiver.class);
        if (extras != null) {
            intent.putExtras(extras);
        }
        intent.setData(Uri.parse((String)("sensorberg" + prefix + ":" + index)));
        return PendingIntent.getBroadcast((Context)this.context, (int)-1, (Intent)intent, (int)0x8000000);
    }

    @SuppressLint(value={"NewApi"})
    private void scheduleAlarm(long delayInMillis, PendingIntent pendingIntent) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.alarmManager.setExact(2, this.clock.elapsedRealtime() + delayInMillis, pendingIntent);
        } else {
            this.alarmManager.set(2, this.clock.elapsedRealtime() + delayInMillis, pendingIntent);
        }
    }

    @Override
    public void cancelServiceMessage(int index) {
        PendingIntent pendingIntent = this.getPendingIntent(index, new Bundle());
        this.alarmManager.cancel(pendingIntent);
    }

    @Override
    public void cancelIntent(int message) {
        PendingIntent pendingIntent = this.getPendingIntent(message);
        this.alarmManager.cancel(pendingIntent);
    }

    @Override
    public void cancelAllScheduledTimer() {
        for (Integer messageType : this.repeatingPendingIntents) {
            this.cancelIntent(messageType);
        }
        this.repeatingPendingIntents.clear();
    }

    @Override
    public void scheduleRepeating(int MSG_type, long value, TimeUnit timeUnit) {
        long millis = TimeUnit.MILLISECONDS.convert(value, timeUnit);
        PendingIntent pendingIntent = this.getPendingIntent(MSG_type);
        this.alarmManager.setInexactRepeating(2, this.clock.elapsedRealtime() + millis, millis, pendingIntent);
        this.repeatingPendingIntents.add(MSG_type);
    }

    @Override
    public void postToServiceDelayed(long delay, int type, Parcelable what, boolean surviveReboot) {
        int index = this.postToServiceCounter.next();
        this.postToServiceDelayed(delay, type, what, surviveReboot, index);
    }

    @Override
    public void postToServiceDelayed(long delayMillis, int type, Parcelable what, boolean surviveReboot, int index) {
        Bundle bundle = this.getScheduleBundle(index, type, what);
        this.scheduleIntent(index, delayMillis, bundle);
        if (surviveReboot) {
            this.pendingIntentStorage.add(index, this.clock.now() + delayMillis, 0, bundle);
        }
    }

    private Bundle getScheduleBundle(int index, int type, Parcelable what) {
        Bundle bundle = new Bundle();
        bundle.putInt("com.sensorberg.android.sdk.intent.generic.type", type);
        bundle.putParcelable("com.sensorberg.android.sdk.intent.generic.what", what);
        bundle.putInt("com.sensorberg.android.sdk.intent.generic.index", index);
        return bundle;
    }

    @Override
    public void postDeliverAtOrUpdate(Date deliverAt, BeaconEvent beaconEvent) {
        long delayInMillis = deliverAt.getTime() - this.clock.now();
        if (delayInMillis < 0L) {
            Logger.log.beaconResolveState(beaconEvent, "scheduled time is in the past, dropping event.");
            return;
        }
        int index = this.postToServiceCounter.next();
        int hashcode = beaconEvent.hashCode();
        Bundle bundle = this.getScheduleBundle(index, 1001, beaconEvent);
        PendingIntent pendingIntent = this.getPendingIntent(hashcode, bundle, "DeliverAt");
        this.scheduleAlarm(delayInMillis, pendingIntent);
        this.pendingIntentStorage.add(index, deliverAt.getTime(), hashcode, bundle);
    }

    @Override
    public void clearAllPendingIntents() {
        this.pendingIntentStorage.clearAllPendingIntents();
    }

    @Override
    public void restorePendingIntents() {
        this.pendingIntentStorage.restorePendingIntents();
    }

    @Override
    public void removeStoredPendingIntent(int index) {
        this.pendingIntentStorage.removeStoredPendingIntent(index);
    }

    @Override
    public void setMessageDelayWindowLength(long messageDelayWindowLength) {
        this.messageDelayWindowLength = messageDelayWindowLength;
    }
}

