/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.model.server;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.sensorberg.sdk.action.Action;
import com.sensorberg.sdk.action.ActionFactory;
import com.sensorberg.sdk.model.BeaconId;
import com.sensorberg.sdk.model.server.Timeframe;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.utils.ListUtils;
import com.sensorberg.utils.UUIDUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.json.JSONException;

public class ResolveAction
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ListUtils.Mapper<ResolveAction, BeaconEvent> BEACON_EVENT_MAPPER = new ListUtils.Mapper<ResolveAction, BeaconEvent>(){

        @Override
        public BeaconEvent map(ResolveAction resolveAction) {
            try {
                Action action = ActionFactory.getAction(resolveAction.type, resolveAction.content, UUID.fromString(UUIDUtils.addUuidDashes(resolveAction.eid)), resolveAction.delay * 1000L);
                if (action == null) {
                    return null;
                }
                return new BeaconEvent.Builder().withAction(action).withSuppressionTime(resolveAction.suppressionTime * 1000L).withSendOnlyOnce(resolveAction.sendOnlyOnce).withDeliverAtDate(resolveAction.deliverAt).withTrigger(resolveAction.trigger).withReportImmediately(resolveAction.reportImmediately).build();
            }
            catch (JSONException e) {
                return null;
            }
        }
    };
    @Expose
    private String eid;
    @Expose
    private int trigger;
    @Expose
    private int type;
    @Expose
    private String name;
    @Expose
    private List<String> beacons;
    @Expose
    private long suppressionTime;
    @Expose
    private boolean sendOnlyOnce;
    @Expose
    private long delay;
    @Expose
    private boolean reportImmediately;
    @Expose
    private JsonObject content;
    @Expose
    private List<Timeframe> timeframes;
    @Expose
    private Date deliverAt;

    public ResolveAction(String uuid, int trigger, int type, String name, List<String> beacons, long suppressionTime, long delay, boolean reportImmediately, JsonObject content, Date deliverAt) {
        this.eid = uuid;
        this.trigger = trigger;
        this.type = type;
        this.name = name;
        this.beacons = beacons;
        this.suppressionTime = suppressionTime;
        this.delay = delay;
        this.reportImmediately = reportImmediately;
        this.content = content;
        this.deliverAt = deliverAt;
    }

    public boolean matchTrigger(int eventMask) {
        return (eventMask & this.trigger) == eventMask;
    }

    public boolean containsBeacon(BeaconId beaconId) {
        String scanEventBid = beaconId.getPid().replace("-", "");
        for (String bid : this.beacons) {
            boolean matchBid = scanEventBid.equalsIgnoreCase(bid.replace("-", ""));
            if (!matchBid) continue;
            return true;
        }
        return false;
    }

    public boolean isValidNow(long now) {
        if (this.timeframes == null || this.timeframes.isEmpty()) {
            return true;
        }
        for (Timeframe timeframe : this.timeframes) {
            boolean valid = timeframe.valid(now);
            if (!valid) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ResolveAction(eid=" + this.eid + ", trigger=" + this.trigger + ", type=" + this.type + ", name=" + this.name + ", beacons=" + this.beacons + ", suppressionTime=" + this.suppressionTime + ", sendOnlyOnce=" + this.sendOnlyOnce + ", delay=" + this.delay + ", reportImmediately=" + this.isReportImmediately() + ", content=" + this.getContent() + ", timeframes=" + this.timeframes + ", deliverAt=" + this.deliverAt + ")";
    }

    public boolean isReportImmediately() {
        return this.reportImmediately;
    }

    public JsonObject getContent() {
        return this.content;
    }

    public static class Builder {
        public String uuid = UUID.randomUUID().toString();
        public int trigger;
        public int type;
        public String name;
        public List<String> beacons;
        public long suppressionTime;
        public long delay;
        public boolean reportImmediately;
        public JsonObject content;
        private Date deliverAt;

        public Builder withDeliverAt(Date deliverAt) {
            this.deliverAt = deliverAt;
            return this;
        }

        public Builder withUuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder withTrigger(int trigger) {
            this.trigger = trigger;
            return this;
        }

        public Builder withType(int type) {
            this.type = type;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withBeacons(List<String> beacons) {
            this.beacons = beacons;
            return this;
        }

        public Builder withSuppressionTime(long suppressionTime) {
            this.suppressionTime = suppressionTime;
            return this;
        }

        public Builder withDelay(long delay) {
            this.delay = delay;
            return this;
        }

        public Builder withReportImmediately(boolean reportImmediately) {
            this.reportImmediately = reportImmediately;
            return this;
        }

        public Builder withContent(JsonObject content) {
            this.content = content;
            return this;
        }

        public ResolveAction build() {
            return new ResolveAction(this.uuid, this.trigger, this.type, this.name, this.beacons, this.suppressionTime, this.delay, this.reportImmediately, this.content, this.deliverAt);
        }
    }
}

