/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.location;

import java.math.BigDecimal;
import java.util.Arrays;

public class GeoHash {
    protected static final byte[] characters = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 98, 99, 100, 101, 102, 103, 104, 106, 107, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    protected static final byte[] map = new byte[123];
    protected static final int BITS_PER_CHARACTER = 5;
    protected static final int MAX_BITS = 60;
    protected static final double[] LATITUDE_RANGE;
    protected static final double[] LONGITUDE_RANGE;
    public final double lat;
    public final double lon;
    public final int precision;
    public final long bitValue;
    public final byte[] hash;

    protected GeoHash(double lat, double lon, long bitValue, byte[] hash) {
        this.lat = lat;
        this.lon = lon;
        this.precision = hash.length;
        this.bitValue = bitValue;
        this.hash = hash;
    }

    public final String toHashString() {
        return new String(this.hash);
    }

    public final String toBinaryRepresentation() {
        return new String(GeoHash.binaryRepresentation(this.bitValue, this.precision));
    }

    public static final GeoHash decode(String hash) {
        return GeoHash.decode(hash.getBytes());
    }

    public static final GeoHash decode(byte[] hash) {
        int lat = 0;
        int lon = 0;
        boolean evenbit = true;
        long binary = 0L;
        for (byte b : hash) {
            b = (byte)(0x1F & map[b]);
            binary <<= 5;
            binary |= (long)b;
            if (evenbit) {
                lon = GeoHash.extractEvenBits(lon, b);
                lat = GeoHash.extractUnevenBits(lat, b);
            } else {
                lat = GeoHash.extractEvenBits(lat, b);
                lon = GeoHash.extractUnevenBits(lon, b);
            }
            evenbit = !evenbit;
        }
        double latitude = GeoHash.decodeCoordinate((long)((long)lat), (Coordinate)new Coordinate((double)0.0, (double[])GeoHash.LATITUDE_RANGE, (int)GeoHash.calculateLatitudeBits((int)hash.length))).coord;
        double longitude = GeoHash.decodeCoordinate((long)((long)lon), (Coordinate)new Coordinate((double)0.0, (double[])GeoHash.LONGITUDE_RANGE, (int)GeoHash.calculateLongitudeBits((int)hash.length))).coord;
        return new GeoHash(latitude, longitude, binary, hash);
    }

    protected static final int calculateLatitudeBits(int precision) {
        return GeoHash.calculateBits(precision, 2);
    }

    protected static final int calculateLongitudeBits(int precision) {
        return GeoHash.calculateBits(precision, 3);
    }

    private static final int calculateBits(int precision, int unevenExtra) {
        return (precision >> 1) * 5 + (precision & 1) * unevenExtra;
    }

    protected static final int extractEvenBits(int value, byte b) {
        value <<= 3;
        value |= (b & 0x10) >> 2;
        value |= (b & 4) >> 1;
        return value |= b & 1;
    }

    protected static final int extractUnevenBits(int value, byte b) {
        value <<= 2;
        value |= (b & 8) >> 2;
        return value |= (b & 2) >> 1;
    }

    protected static final Coordinate decodeCoordinate(long bitCoord, Coordinate coord) {
        double val = 0.0;
        int mask = 1 << coord.bits;
        while ((mask >>= 1) >= 1) {
            if (((long)mask & bitCoord) > 0L) {
                coord.min = val;
                val = (val + coord.max) / 2.0;
                continue;
            }
            coord.max = val;
            val = (val + coord.min) / 2.0;
        }
        coord.coord = new BigDecimal(val).setScale(coord.bits / 5, 4).doubleValue();
        return coord;
    }

    public static final GeoHash encode(double lat, double lon, int precision) {
        if (precision < 1) {
            precision = 1;
        }
        Coordinate latInfo = new Coordinate(lat, LATITUDE_RANGE, GeoHash.calculateLatitudeBits(precision));
        Coordinate lonInfo = new Coordinate(lon, LONGITUDE_RANGE, GeoHash.calculateLongitudeBits(precision));
        long mask = 1L << Math.min(precision * 5, 60);
        long bitValue = 0L;
        boolean even = true;
        while ((mask >>= 1) > 0L) {
            bitValue = even ? GeoHash.encode(bitValue, lonInfo) : GeoHash.encode(bitValue, latInfo);
            even = !even;
        }
        return new GeoHash(lat, lon, bitValue, GeoHash.translateBinaryToHash(bitValue, precision));
    }

    public static final GeoHash encode(double lat, double lon) {
        return GeoHash.encode(lat, lon, 12);
    }

    protected static final long encode(long bitValue, Coordinate info) {
        info.mid = (info.min + info.max) / 2.0;
        if (info.coord >= info.mid) {
            bitValue <<= 1;
            bitValue |= 1L;
            info.min = info.mid;
        } else {
            bitValue <<= 1;
            info.max = info.mid;
        }
        return bitValue;
    }

    protected static final byte[] translateBinaryToHash(long value, int precision) {
        byte[] h = new byte[precision];
        while (precision > 0) {
            h[--precision] = characters[(byte)(value & 0x1FL)];
            value >>= 5;
        }
        return h;
    }

    protected static final String binaryRepresentation(long bitValue, int precision) {
        char[] rep = new char[Math.min(precision * 5, 60)];
        int index = 0;
        long mask = 1L << rep.length;
        while ((mask >>= 1) >= 1L) {
            rep[index++] = (mask & bitValue) > 0L ? 49 : 48;
        }
        return new String(rep);
    }

    public String toString() {
        return String.format("%f %f %d %s", this.lat, this.lon, this.bitValue, GeoHash.binaryRepresentation(this.bitValue, this.precision));
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof GeoHash) {
            return Arrays.equals(((GeoHash)obj).hash, this.hash);
        }
        return false;
    }

    public int hashCode() {
        return new String(this.hash).hashCode();
    }

    static {
        for (int i = 0; i < characters.length; i = (int)((byte)(i + 1))) {
            GeoHash.map[GeoHash.characters[i]] = i;
        }
        LATITUDE_RANGE = new double[]{-90.0, 90.0};
        LONGITUDE_RANGE = new double[]{-180.0, 180.0};
    }

    protected static final class Coordinate {
        protected double coord;
        protected double min;
        protected double max;
        protected double mid;
        protected int bits;

        public Coordinate(double coordinate, double[] range, int bits) {
            this.coord = coordinate;
            this.min = range[0];
            this.max = range[1];
            this.mid = 0.0;
            this.bits = bits;
        }
    }
}

