/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal.transport;

import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.interfaces.BeaconHistoryUploadIntervalListener;
import com.sensorberg.sdk.internal.interfaces.BeaconResponseHandler;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.internal.transport.CallbackWithRetry;
import com.sensorberg.sdk.internal.transport.RetrofitApiServiceImpl;
import com.sensorberg.sdk.internal.transport.interfaces.Transport;
import com.sensorberg.sdk.internal.transport.interfaces.TransportHistoryCallback;
import com.sensorberg.sdk.internal.transport.interfaces.TransportSettingsCallback;
import com.sensorberg.sdk.internal.transport.model.HistoryBody;
import com.sensorberg.sdk.internal.transport.model.SettingsResponse;
import com.sensorberg.sdk.model.persistence.ActionConversion;
import com.sensorberg.sdk.model.persistence.BeaconAction;
import com.sensorberg.sdk.model.persistence.BeaconScan;
import com.sensorberg.sdk.model.server.ResolveAction;
import com.sensorberg.sdk.model.server.ResolveResponse;
import com.sensorberg.sdk.receivers.NetworkInfoBroadcastReceiver;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.sdk.scanner.ScanEvent;
import com.sensorberg.utils.ListUtils;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class RetrofitApiTransport
implements Transport {
    public static String RESOLVER_BASE_URL = "https://demo.sensorberg-cdn.com";
    public static int BACKEND_VERSION = 2;
    private final Clock mClock;
    private RetrofitApiServiceImpl apiService;
    private ResolveResponse lastSuccess;
    private SharedPreferences prefs;
    private Gson gson;
    private BeaconHistoryUploadIntervalListener beaconHistoryUploadIntervalListener = BeaconHistoryUploadIntervalListener.NONE;
    private Transport.ProximityUUIDUpdateHandler mProximityUUIDUpdateHandler = Transport.ProximityUUIDUpdateHandler.NONE;

    public RetrofitApiTransport(RetrofitApiServiceImpl retrofitApiService, Clock clk, SharedPreferences sharedPreferences, Gson gson) {
        this.apiService = retrofitApiService;
        this.mClock = clk;
        this.prefs = sharedPreferences;
        this.gson = gson;
        this.load();
    }

    private RetrofitApiServiceImpl getApiService() {
        return this.apiService;
    }

    private void load() {
        String json = this.prefs.getString("com.sensorberg.preferences.transport.resolved", null);
        if (!TextUtils.isEmpty((CharSequence)json)) {
            this.lastSuccess = (ResolveResponse)this.gson.fromJson(json, ResolveResponse.class);
        }
    }

    private void save(ResolveResponse body) {
        this.lastSuccess = body;
        this.prefs.edit().putString("com.sensorberg.preferences.transport.resolved", this.gson.toJson((Object)this.lastSuccess)).apply();
    }

    @Override
    public void setProximityUUIDUpdateHandler(Transport.ProximityUUIDUpdateHandler proximityUUIDUpdateHandler) {
        this.mProximityUUIDUpdateHandler = proximityUUIDUpdateHandler != null ? proximityUUIDUpdateHandler : Transport.ProximityUUIDUpdateHandler.NONE;
    }

    private boolean isModified(Response<ResolveResponse> response) {
        String header = response.headers().get("okhttp-header");
        return !String.valueOf(304).equals(header);
    }

    @Override
    public void getBeacon(final ScanEvent scanEvent, SortedMap<String, String> attributes, final BeaconResponseHandler beaconResponseHandler) {
        String networkInfo = NetworkInfoBroadcastReceiver.latestNetworkInfo != null ? NetworkInfoBroadcastReceiver.getNetworkInfoString() : "";
        this.getApiService().getBeacon(scanEvent.getBeaconId().getPid(), networkInfo, attributes).enqueue((Callback)new Callback<ResolveResponse>(){

            public void onResponse(Call<ResolveResponse> call, Response<ResolveResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    RetrofitApiTransport.this.save((ResolveResponse)response.body());
                    this.onSuccess((ResolveResponse)response.body(), RetrofitApiTransport.this.isModified((Response<ResolveResponse>)response));
                } else {
                    this.onFail(new Throwable("No Content, Invalid Api Key"));
                }
            }

            public void onFailure(Call<ResolveResponse> call, Throwable t) {
                this.onFail(t);
            }

            void onSuccess(ResolveResponse resolveResponse, boolean changed) {
                List beaconEvents = RetrofitApiTransport.this.checkSuccessfulBeaconResponse(scanEvent, resolveResponse);
                beaconResponseHandler.onSuccess(beaconEvents);
                RetrofitApiTransport.this.checkShouldCallBeaconResponseHandlers(resolveResponse, changed);
            }

            void onFail(Throwable t) {
                if (RetrofitApiTransport.this.lastSuccess == null) {
                    beaconResponseHandler.onFailure(t);
                } else {
                    Logger.log.logError("resolution failed, but we have a backup:" + scanEvent.getBeaconId().toTraditionalString(), t);
                    this.onSuccess(RetrofitApiTransport.this.lastSuccess, false);
                }
            }
        });
    }

    private void checkShouldCallBeaconResponseHandlers(ResolveResponse successfulResponse, boolean changed) {
        this.mProximityUUIDUpdateHandler.proximityUUIDListUpdated(successfulResponse.getAccountProximityUUIDs(), changed);
        if (successfulResponse.reportTriggerSeconds != null) {
            this.beaconHistoryUploadIntervalListener.historyUploadIntervalChanged(TimeUnit.SECONDS.toMillis(successfulResponse.reportTriggerSeconds));
        }
    }

    private List<BeaconEvent> checkSuccessfulBeaconResponse(ScanEvent scanEvent, ResolveResponse successfulResponse) {
        List<ResolveAction> resolveActions = successfulResponse.resolve(scanEvent, this.mClock.now());
        List<BeaconEvent> beaconEvents = ListUtils.map(resolveActions, ResolveAction.BEACON_EVENT_MAPPER);
        for (BeaconEvent beaconEvent : beaconEvents) {
            beaconEvent.setBeaconId(scanEvent.getBeaconId());
            beaconEvent.setTrigger(scanEvent.getTrigger());
            beaconEvent.setResolvedTime(this.mClock.now());
            beaconEvent.setGeohash(scanEvent.getGeohash());
        }
        return beaconEvents;
    }

    @Override
    public boolean setApiToken(String apiToken) {
        return this.getApiService().setApiToken(apiToken);
    }

    @Override
    public void loadSettings(final TransportSettingsCallback transportSettingsCallback) {
        Call<SettingsResponse> call = this.getApiService().getSettings();
        this.enqueueWithRetry(call, new Callback<SettingsResponse>(){

            public void onResponse(Call<SettingsResponse> call, Response<SettingsResponse> response) {
                if (response.isSuccessful()) {
                    if (response.code() == 204) {
                        transportSettingsCallback.onSettingsFound(null);
                    } else {
                        transportSettingsCallback.onSettingsFound((SettingsResponse)response.body());
                    }
                } else if (response.code() == 304) {
                    transportSettingsCallback.nothingChanged();
                } else {
                    transportSettingsCallback.onFailure(new Exception());
                }
            }

            public void onFailure(Call<SettingsResponse> call, Throwable t) {
                transportSettingsCallback.onFailure(new Exception(t));
            }
        });
    }

    @Override
    public void publishHistory(final List<BeaconScan> scans, final List<BeaconAction> actions, final List<ActionConversion> conversions, final TransportHistoryCallback callback) {
        HistoryBody body = new HistoryBody(scans, actions, conversions, this.mClock);
        Call<ResponseBody> call = this.getApiService().publishHistory(body);
        call.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                if (response.isSuccessful()) {
                    callback.onSuccess(scans, actions, conversions);
                    if (response.body() != null) {
                        try {
                            ResolveResponse resolveResponse = (ResolveResponse)((RetrofitApiTransport)RetrofitApiTransport.this).apiService.mGson.fromJson(((ResponseBody)response.body()).charStream(), ResolveResponse.class);
                            if (resolveResponse != null) {
                                callback.onInstantActions(resolveResponse.getInstantActionsAsBeaconEvent());
                            }
                        }
                        catch (Exception e) {
                            Logger.log.logError("Failed to de-serialize publishHistory response body", e);
                        }
                    }
                } else {
                    callback.onFailure(new Exception("No Content, Invalid Api Key"));
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                callback.onFailure(new Exception(t));
            }
        });
    }

    @Override
    public void updateBeaconLayout(SortedMap<String, String> attributes) {
        this.getApiService().updateBeaconLayout(attributes).enqueue((Callback)new Callback<ResolveResponse>(){

            public void onResponse(Call<ResolveResponse> call, Response<ResolveResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    RetrofitApiTransport.this.save((ResolveResponse)response.body());
                    this.onSuccess((ResolveResponse)response.body(), RetrofitApiTransport.this.isModified((Response<ResolveResponse>)response));
                } else {
                    this.onFail(new Exception("Failed to updateBeaconLayout. Response body is empty"));
                }
            }

            public void onFailure(Call<ResolveResponse> call, Throwable t) {
                this.onFail(t);
            }

            void onSuccess(ResolveResponse resolveResponse, boolean changed) {
                RetrofitApiTransport.this.mProximityUUIDUpdateHandler.proximityUUIDListUpdated(resolveResponse.getAccountProximityUUIDs(), changed);
            }

            void onFail(Throwable t) {
                if (RetrofitApiTransport.this.lastSuccess == null) {
                    Logger.log.logError("UpdateBeaconLayout failed", t);
                    RetrofitApiTransport.this.mProximityUUIDUpdateHandler.proximityUUIDListUpdated(Collections.EMPTY_LIST, true);
                } else {
                    Logger.log.logError("UpdateBeaconLayout failed, but we have a backup", t);
                    this.onSuccess(RetrofitApiTransport.this.lastSuccess, false);
                }
            }
        });
    }

    @Override
    public void setLoggingEnabled(boolean enabled) {
        this.getApiService().setLoggingEnabled(enabled);
    }

    public <T> void enqueueWithRetry(Call<T> call, Callback<T> callback) {
        call.enqueue(new CallbackWithRetry<T>(callback));
    }

    @Override
    public void setBeaconHistoryUploadIntervalListener(BeaconHistoryUploadIntervalListener beaconHistoryUploadIntervalListener) {
        this.beaconHistoryUploadIntervalListener = beaconHistoryUploadIntervalListener;
    }
}

