/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.action;

import android.os.Parcel;
import android.os.Parcelable;
import com.sensorberg.sdk.action.Action;
import com.sensorberg.sdk.action.ActionType;
import com.sensorberg.utils.Objects;
import java.util.UUID;

public class UriMessageAction
extends Action {
    public static final Parcelable.Creator<UriMessageAction> CREATOR = new Parcelable.Creator<UriMessageAction>(){

        public UriMessageAction createFromParcel(Parcel in) {
            return new UriMessageAction(in);
        }

        public UriMessageAction[] newArray(int size) {
            return new UriMessageAction[size];
        }
    };
    private final String title;
    private final String content;
    private final String uri;

    public UriMessageAction(UUID actionUUID, String title, String content, String uri, String payload, long delayTime) {
        super(ActionType.MESSAGE_URI, delayTime, actionUUID, payload);
        this.title = title;
        this.content = content;
        this.uri = uri;
    }

    private UriMessageAction(Parcel source) {
        super(source);
        this.title = source.readString();
        this.content = source.readString();
        this.uri = source.readString();
    }

    @Override
    public int hashCode() {
        return this.title.hashCode() + this.content.hashCode() + this.uri.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UriMessageAction that = (UriMessageAction)o;
        return Objects.equals(this.content, that.content) && Objects.equals(this.title, that.title) && Objects.equals(this.uri, that.uri);
    }

    @Override
    public void writeToParcel(Parcel destination, int flags) {
        super.writeToParcel(destination, flags);
        destination.writeString(this.title);
        destination.writeString(this.content);
        destination.writeString(this.uri);
    }

    @Override
    public String toString() {
        return "UriMessageAction(title=" + this.getTitle() + ", content=" + this.getContent() + ", uri=" + this.getUri() + ")";
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public String getUri() {
        return this.uri;
    }
}

