/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal;

import android.content.Context;
import android.os.Bundle;
import com.sensorberg.SensorbergSdk;
import com.sensorberg.sdk.internal.SQLiteStore;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.internal.interfaces.ServiceScheduler;
import java.util.ArrayList;
import javax.inject.Inject;

public class PendingIntentStorage {
    private final ServiceScheduler serviceScheduler;
    private final SQLiteStore storage;
    @Inject
    protected Context context;
    private Clock clock;

    public PendingIntentStorage(ServiceScheduler serviceScheduler, Clock clk) {
        this.serviceScheduler = serviceScheduler;
        this.clock = clk;
        SensorbergSdk.getComponent().inject(this);
        this.storage = new SQLiteStore("pendingIntentStorage.sqlite", this.context);
    }

    public void add(int index, long timestamp, int identifier, Bundle bundle) {
        this.storage.deleteByIdentifier(identifier);
        this.storage.put(new SQLiteStore.Entry(index, timestamp, identifier, bundle));
    }

    public void restorePendingIntents() {
        this.storage.deleteOlderThan(this.clock.now());
        ArrayList<SQLiteStore.Entry> entries = this.storage.loadRegistry();
        for (SQLiteStore.Entry entry : entries) {
            long relativeFromNow = entry.timestamp - this.clock.now();
            this.serviceScheduler.scheduleIntent(entry.index, relativeFromNow, entry.bundle);
        }
    }

    public void clearAllPendingIntents() {
        ArrayList<SQLiteStore.Entry> entries = this.storage.loadRegistry();
        for (SQLiteStore.Entry entry : entries) {
            this.serviceScheduler.unscheduleIntent(entry.index);
        }
        this.storage.clear();
    }

    public void removeStoredPendingIntent(int index) {
        this.storage.delete(index);
    }
}

