/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.interfaces.RunLoop;
import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;

public class AndroidHandler
implements RunLoop {
    private final LooperThread looper;
    private Timer timer;

    public AndroidHandler(RunLoop.MessageHandlerCallback messageHandlerCallback) {
        this.looper = new LooperThread(messageHandlerCallback);
        this.looper.start();
    }

    @Override
    public void add(Message event) {
        this.getHandler().sendMessage(event);
    }

    @Override
    public void clearScheduledExecutions() {
        if (this.looper.handler != null) {
            this.looper.handler.removeCallbacksAndMessages(null);
        }
    }

    @Override
    public void scheduleExecution(Runnable runnable, long wait_time) {
        if (wait_time > 0L) {
            boolean result;
            if (wait_time > 86400000L) {
                wait_time = 86400000L;
            }
            if (!(result = this.getHandler().postDelayed(runnable, wait_time))) {
                Logger.log.logError("could not schedule the runnable in " + wait_time + " millis");
            }
        } else {
            runnable.run();
        }
    }

    private Handler getHandler() {
        while (this.looper.handler == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Logger.log.logError("looper was null, so we tried to sleep the thread...", e);
            }
        }
        return this.looper.handler;
    }

    @Override
    public void scheduleAtFixedRate(TimerTask timerTask, int when, long interval) {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            Logger.log.logError("There is already an execution scheduled");
        }
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(timerTask, when, interval);
    }

    @Override
    public void cancelFixedRateExecution() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @Override
    public Message obtainMessage(int what) {
        return this.getHandler().obtainMessage(what);
    }

    @Override
    public Message obtainMessage(int what, Object obj) {
        return this.getHandler().obtainMessage(what, obj);
    }

    @Override
    public void sendMessage(int what) {
        this.add(this.obtainMessage(what));
    }

    @Override
    public void sendMessage(int what, Object obj) {
        this.add(this.obtainMessage(what, obj));
    }

    static class LooperThread
    extends Thread {
        public Handler handler;
        private RunLoop.MessageHandlerCallback messageHandlerCallback;

        LooperThread(RunLoop.MessageHandlerCallback messageHandlerCallback) {
            this.messageHandlerCallback = messageHandlerCallback;
        }

        @Override
        public void run() {
            Looper.prepare();
            this.handler = new StaticHandler(this.messageHandlerCallback);
            this.messageHandlerCallback = null;
            Looper.loop();
        }

        private static class StaticHandler
        extends Handler {
            private final WeakReference<RunLoop.MessageHandlerCallback> messageHandlerCallback;

            public StaticHandler(RunLoop.MessageHandlerCallback messageHandlerCallback) {
                this.messageHandlerCallback = new WeakReference<RunLoop.MessageHandlerCallback>(messageHandlerCallback);
            }

            public void handleMessage(Message msg) {
                RunLoop.MessageHandlerCallback messageHandlerCallback = (RunLoop.MessageHandlerCallback)this.messageHandlerCallback.get();
                if (messageHandlerCallback != null) {
                    messageHandlerCallback.handleMessage(msg);
                }
            }
        }
    }
}

